#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';
use Test::Deep;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;
use qbit;

run_tests(
    sub {
        my ($app) = @_;
        my $model = $app->internal_mobile_app;

        my $got = {};

        my @multistates = keys %{$model->get_multistates()};

        for my $multistate (@multistates) {
            (my $multistate_name = $model->get_multistate_name($multistate)) =~ s/\n/ /g;
            $got->{mult2single}{$multistate} = [$multistate_name, $model->_multistate_to_single_state($multistate)];
        }

        my $expected = get_test_data_and_update_if_needed('data.json', $got);

        eq_or_diff($got, $expected, 'compare mapping');

    },
    dont_create_database => 1
);
