use qbit;

use Test::Differences;
use Test::Partner2::Simple;
use Test::More;
use Test::Partner::Utils qw(convert_design_to_object);
use PiConstants qw($IS_PRECISE);

run_tests(
    sub {
        my ($app) = @_;

        my $fields = $app->internal_mobile_app_rtb->get_model_fields();
        my $block = $app->internal_mobile_app_rtb->get({campaign_id => 132439, id => 2}, fields => [keys %$fields]);
        my $article_tree = $app->internal_mobile_app_rtb->tns_dict_article->get_real_article_tree();
        my $bk_block = $app->internal_mobile_app_rtb->get_bk_block_data($block, $article_tree);

        if ($IS_PRECISE) {
            $bk_block->{DirectLimit} += 0;
        }

        eq_or_diff(
            $bk_block,
            {
                'BlockCaption' => 'Yandex.Metro Interstitial (iOs)',
                'BlockType'    => 'interstitial',
                'Sizes'        => [
                    {
                        'Height' => '480',
                        'Width'  => '320'
                    },
                    {
                        'Height' => 0,
                        'Width'  => 0
                    }
                ],
                'RtbDesign' => convert_design_to_object(
'"blockId":"R-IM-132439-2","borderRadius":false,"borderType":"none","favicon":true,"headerBgColor":"FEEAC7","horizontalAlign":false,"hoverColor":"0066FF","limit":"2","linksUnderline":true,"name":"interstitial","noSitelinks":false,"siteBgColor":"FFFFFF","sitelinksColor":"0000CC","textColor":"000000","titleColor":"0000CC","urlColor":"006600"',
                ),
                'Width'      => '320',
                'MultiState' => '2',
                'AdTypeSet'  => {
                    'video-performance' => 0,
                    'video'             => 0,
                    'video-motion'      => 0,
                    'media'             => 1,
                    'text'              => 1,
                    'media-performance' => 0
                },
                'OptimizeType'      => 0,
                'DSPType'           => 4,
                'InterstitialBlock' => 1,
                'Article'           => {},
                'PICategoryIAB'     => {},
                'Height'            => '480',
                'AdType'            => {},
                'DirectLimit'       => 2,
                'DSPInfo'           => [],
                'DSPSettings'       => {
                    'DSP'         => [],
                    'DSPBindMode' => 'force',
                    'Unmoderated' => []
                },
                'MinCPM'         => 15000,
                'Brand'          => {},
                'Geo'            => {},
                'PageImpOptions' => {'Disable' => ['no-mobile-app', 'only-mobile-app',],},
                'OrderTags'      => [],
                'TargetTags'     => [],
                'CustomBlockData' => {'close-button-delay' => 2,},
            },
            'bk block',
            {context => 10}
        );
    },
);
