#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use DDP;
use Test::Most;
use Test::More;
use Test::Deep;
use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use qbit;

my $today = '2014-01-16';

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_curdate("$today 00:00:00");
        mock_utils_partner2($app);

        throws_ok(
            sub {$app->internal_search_on_site_campaign->add()},
            'Exception::Validator::Errors',
            'exception on missed fields'
        );

        my $id = $app->internal_search_on_site_campaign->add(
            block_title => 'Test title',
            comment     => 'Test comment',
            #type        => '1',
            domain => 'test.test',
        );

        my $modef_fields = $app->internal_search_on_site_campaign->get_model_fields();

        my $got = $app->internal_search_on_site_campaign->get_all(
            filter => {id => $id},
            fields => [keys %$modef_fields]
        );

        my $expected = get_test_data_and_update_if_needed('data.json', $got->[0]);

        cmp_deeply($got->[0], $expected, 'Add internal_search_on_site_campaign');

        $app->internal_search_on_site_campaign->do_action($id, 'edit', comment => 'foo');

        cmp_deeply(
            $app->internal_search_on_site_campaign->get($id, fields => ['comment']),
            {comment => 'foo'},
            'Edit comment'
        );

    },
    user => 'mocked-internal-administrator',
);
