#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::Deep;

use qbit;

my $CAMP_ID = 118826;

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);

        cmp_deeply(
            $app->internal_search_on_site_campaign->get(
                $CAMP_ID, fields => [qw(id banner_lang banner_lang_name page_lang page_lang_name)]
            ),
            {
                id               => $CAMP_ID,
                banner_lang      => [1],
                banner_lang_name => ['ru'],
                page_lang        => 1,
                page_lang_name   => 'ru',
            },
            'check db data'
        );

        $app->internal_search_on_site_campaign->do_action($CAMP_ID, 'edit', banner_lang => [2, 3], page_lang => 5);

        cmp_deeply(
            $app->internal_search_on_site_campaign->get(
                $CAMP_ID, fields => [qw(id banner_lang banner_lang_name page_lang page_lang_name)]
            ),
            {
                id               => $CAMP_ID,
                banner_lang      => [2, 3],
                banner_lang_name => ['en', 'uk'],
                page_lang        => 5,
                page_lang_name   => 'kz',
            },
            'check edit campaign'
        );
    },
);
