#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::Deep;

use qbit;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_curdate mock_subs restore_subs);

my $PAGE = {
    'AdaptiveGroupID'          => 0,
    'BannerLang'               => 31,
    'BannerLangBy'             => JSON::XS::true,
    'BannerLangDe'             => JSON::XS::false,
    'BannerLangEn'             => JSON::XS::true,
    'BannerLangEt'             => JSON::XS::false,
    'BannerLangHe'             => JSON::XS::false,
    'BannerLangKz'             => JSON::XS::true,
    'BannerLangLt'             => JSON::XS::false,
    'BannerLangLv'             => JSON::XS::false,
    'BannerLangPt'             => JSON::XS::false,
    'BannerLangRu'             => JSON::XS::true,
    'BannerLangTr'             => JSON::XS::false,
    'BannerLangTt'             => JSON::XS::false,
    'BannerLangUk'             => JSON::XS::true,
    'BannerLangUz'             => JSON::XS::false,
    'BannerLangVi'             => JSON::XS::false,
    'BaseNo'                   => 13,
    'BaseNo2'                  => 12,
    'BlockPageID'              => 3845,
    'BlockSettingsID'          => 0,
    'CTRPredictionID'          => 0,
    'CategoryKeywordID'        => 79,
    'ContentType'              => 'application/x-javascript',
    'ContentTypeAsInt'         => 5,
    'Conversion'               => 100,
    'CookieMatchTag'           => '',
    'CopyParentPageID'         => 0,
    'CreateTime'               => 1577658399,
    'DSPPageID'                => 3948,
    'DebugTags'                => '',
    'DefaultCharset'           => 'utf-8',
    'DefaultCharsetAsInt'      => 2,
    'Description'              => 'samostrah.ru',
    'DisabledFlags'            => '2251799813685248',
    'DisabledTagsJsonOptionID' => 0,
    'EditTime'                 => 1577680731,
    'ExpGroupID'               => 2,
    'ExtBlockID'               => 0,
    'ExtJsonOptionID'          => 0,
    'HitLogProb'               => 0,
    'ImpCPMParamID'            => 0,
    'Lang'                     => 'ru',
    'LangAsInt'                => 1,
    'MNGroupID'                => 0,
    'MatchJsonOptionID'        => 0,
    'MinCPM'                   => 0,
    'MixTargetingParamID'      => 0,
    'Name'                     => 'samostrah.ru',
    'Options'                  => '299084355274240',
    'OptionsAdblock'           => JSON::XS::false,
    'OptionsAdvq'              => JSON::XS::false,
    'OptionsAllAdsPage'        => JSON::XS::false,
    'OptionsAllowFewRef'       => JSON::XS::false,
    'OptionsAllowFewUrl'       => JSON::XS::false,
    'OptionsAllowInfRef'       => JSON::XS::false,
    'OptionsAllowInfUrl'       => JSON::XS::false,
    'OptionsApp'               => JSON::XS::false,
    'OptionsAsString' =>
      'getuprof,yacofast,directpic,yacofast3,get_yacofast,context,redir-to-page-handler,check-target-ref-only',
    'OptionsBusinessUnit'             => JSON::XS::false,
    'OptionsCheckTargetRefOnly'       => JSON::XS::true,
    'OptionsContext'                  => JSON::XS::true,
    'OptionsDirectpic'                => JSON::XS::true,
    'OptionsDisableClusterization'    => JSON::XS::false,
    'OptionsDistrdownloads'           => JSON::XS::false,
    'OptionsDistribAdv'               => JSON::XS::false,
    'OptionsDistribMorda'             => JSON::XS::false,
    'OptionsDistribSerp'              => JSON::XS::false,
    'OptionsEnableCpmSource'          => JSON::XS::false,
    'OptionsExactLocation'            => JSON::XS::false,
    'OptionsFactorStat'               => JSON::XS::false,
    'OptionsFamily'                   => JSON::XS::false,
    'OptionsForceRtbSmartAmnesty'     => JSON::XS::false,
    'OptionsForceYclid'               => JSON::XS::false,
    'OptionsFullExpStat'              => JSON::XS::false,
    'OptionsGetSrcFromDomainList'     => JSON::XS::false,
    'OptionsGetYacofast'              => JSON::XS::true,
    'OptionsGetbehav'                 => JSON::XS::false,
    'OptionsGetstat'                  => JSON::XS::false,
    'OptionsGetuprof'                 => JSON::XS::true,
    'OptionsHitCookieMatch'           => JSON::XS::false,
    'OptionsIgnoreBmDisPartner'       => JSON::XS::false,
    'OptionsIgnoreDomainCheck'        => JSON::XS::false,
    'OptionsMainSerp'                 => JSON::XS::false,
    'OptionsMobile'                   => JSON::XS::false,
    'OptionsMobileFalseClick'         => JSON::XS::false,
    'OptionsNoMobileApp'              => JSON::XS::false,
    'OptionsNoRtbSmartAmnesty'        => JSON::XS::false,
    'OptionsNoSaas'                   => JSON::XS::false,
    'OptionsNoTurl'                   => JSON::XS::false,
    'OptionsNobehav'                  => JSON::XS::false,
    'OptionsNocontext'                => JSON::XS::false,
    'OptionsOnlyMobileApp'            => JSON::XS::false,
    'OptionsOnlyPicture'              => JSON::XS::false,
    'OptionsOnlyPortalTrustedBanners' => JSON::XS::false,
    'OptionsOnlyTrustedOrders'        => JSON::XS::false,
    'OptionsPermstat'                 => JSON::XS::false,
    'OptionsPrefetch'                 => JSON::XS::false,
    'OptionsProtected'                => JSON::XS::false,
    'OptionsRedirToPageHandler'       => JSON::XS::true,
    'OptionsRtbPage'                  => JSON::XS::false,
    'OptionsSearchPageWithIgnoreWww'  => JSON::XS::false,
    'OptionsServerSideUserBans'       => JSON::XS::false,
    'OptionsSsp'                      => JSON::XS::false,
    'OptionsTagstat'                  => JSON::XS::false,
    'OptionsUnmoderatedRtbAuction'    => JSON::XS::false,
    'OptionsVideo'                    => JSON::XS::false,
    'OptionsVisualDirect'             => JSON::XS::false,
    'OptionsWriteSspResponseLog'      => JSON::XS::false,
    'OptionsYacofast'                 => JSON::XS::true,
    'OptionsYacofast3'                => JSON::XS::true,
    'OptionsYandexApp'                => JSON::XS::false,
    'OptionsYandexGroup'              => JSON::XS::false,
    'OptionsYandexPage'               => JSON::XS::false,
    'OptionsYpUserBans'               => JSON::XS::false,
    'OrderTags'                       => '',
    'OrigPageID'                      => 491898,
    'PageBits'                        => 128,
    'PageID'                          => 491898,
    'PageParamID'                     => 0,
    'PageSelect'                      => 32784,
    'PerfLimitParamID'                => 0,
    'Premium'                         => 0,
    'RFJsonOptionID'                  => 0,
    'ReadOnly'                        => 0,
    'SearchSouthParamID'              => 0,
    'ShowProb'                        => 0,
    'SourceBit'                       => 0,
    'StartTime'                       => 0,
    'State'                           => 1,
    'Store'                           => '',
    'StoreAsInt'                      => 1,
    'TagKeywordID'                    => 104,
    'TargetTags'                      => '',
    'TargetType'                      => 3,
    'TemplateFile'                    => '',
    'TrustLevel'                      => 0,
    'UniqKeywordID'                   => 0,
    'Valid'                           => 0,
    'YTHash'                          => '7909220385263650572',
};

my $PARTNER_PAGE = {
    'DomainFilter' => 'samostrah.ru',
    'DomainList' =>
'samostrah.ru,yandex-team.ru,yandex.az,yandex.by,yandex.co.il,yandex.com,yandex.com.am,yandex.com.ge,yandex.com.tr,yandex.ee,yandex.fr,yandex.kg,yandex.kz,yandex.lt,yandex.lv,yandex.md,yandex.ru,yandex.tj,yandex.tm,yandex.ua,yandex.uz,yastatic.net',
    'DomainPicFilter' => '',
    'Login'           => 'dn-sm',
    'PageID'          => 491898,
    'PartnerGroup'    => 72133834,
    'PartnerID'       => 72133834,
    'PartnerOwner'    => 0,
    'URLTemplate'     => '',
    'YTHash'          => '7909220385263650572',
};

my $FIXTURES = [
    {
        model       => 'internal_context_on_site_campaign',
        target_type => 3,
        page_id     => 491898,
    },
    {
        model       => 'internal_search_on_site_campaign',
        target_type => 2,
        page_id     => 491899,
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2019-12-30 20:30:00');

        my $page;
        my $partner_page;

        restore_subs(['LWP::UserAgent::request']);
        mock_subs(
            {
                'LWP::UserAgent::request' => sub {
                    my ($self, $url) = @_;

                    my $r = HTTP::Response->new(200);
                    $r->request(HTTP::Request->new());

                    $r->content(
                        to_json($url->headers->header('x-yt-parameters') =~ /PartnerPage/ ? $partner_page : $page));

                    return $r;
                  }
            }
        );

        my %data = ();
        foreach my $test (@$FIXTURES) {
            my $model       = $test->{'model'};
            my $page_id     = $test->{'page_id'};
            my $target_type = $test->{'target_type'};

            $page = {%$PAGE, PageID => $page_id, TargetType => $target_type,};
            $partner_page = {%$PARTNER_PAGE, PageID => $page_id,};

            $app->$model->import_from_bk($page_id);

            $data{$model} = $app->$model->get($page_id, fields => ['*']);
        }

        my $expected = get_test_data_and_update_if_needed('pages.json', \%data);

        cmp_deeply(\%data, $expected, 'check imported pages');
    },
);
