#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use qbit;

use Test::More;

my $fixture = {
    'context_on_site_campaign' => [
        {
            page_id   => 41443,
            domain    => 'approvedmirror.ru',
            exception => 'Mirror "approvedmirror.ru" already exists'
        },
        {
            page_id   => 41443,
            domain    => 'foo.approvedmirror.ru',
            exception => 'You should not add a subdomain as a mirror if a higher level domain is already added'
        },
        {
            page_id   => 'foobar',
            domain    => 'foo.bar',
            exception => 'Incorrect Page ID: "foobar"'
        },
        {
            page_id   => 41443,
            domain    => 'foo bar',
            exception => 'Invalid domain: "foo bar"',
            result    => undef
        },
        {
            page_id => 41443,
            domain  => 'foo.bar',
            result  => 1
        },
        {
            page_id   => 41443,
            domain    => 'rejected.com',
            result    => undef,
            exception => 'Mirror cannot be added. Domain "rejected.com" rejected.',
        },
    ],
    'search_on_site_campaign' => [
        {
            page_id   => 111161,
            domain    => 'approvedmirror.ru',
            exception => 'Mirror "approvedmirror.ru" already exists'
        },
        {
            page_id   => 111161,
            domain    => 'foo.approvedmirror.ru',
            exception => 'You should not add a subdomain as a mirror if a higher level domain is already added'
        },
        {
            page_id   => 'foobar',
            domain    => 'foo.bar',
            exception => 'Incorrect Page ID: "foobar"'
        },
        {
            page_id   => 111161,
            domain    => 'foo bar',
            exception => 'Invalid domain: "foo bar"'
        },
        {
            page_id => 111161,
            domain  => 'foo.bar',
            result  => 1
        },
        {
            page_id   => 111161,
            domain    => 'rejected.com',
            result    => undef,
            exception => 'Mirror cannot be added. Domain "rejected.com" rejected.',
        },
    ],
    'internal_context_on_site_campaign' => [
        {
            page_id   => 2,
            domain    => 'approvedmirror.ru',
            exception => 'Mirror "approvedmirror.ru" already exists'
        },
        {
            page_id   => 2,
            domain    => 'foo.approvedmirror.ru',
            exception => 'You should not add a subdomain as a mirror if a higher level domain is already added'
        },
        {
            page_id   => 'foobar',
            domain    => 'foo.bar',
            exception => 'Incorrect Page ID: "foobar"'
        },
        {
            page_id   => 2,
            domain    => 'foo bar',
            exception => 'Invalid domain: "foo bar"',
            result    => undef
        },
        {
            page_id => 2,
            domain  => 'foo.bar',
            result  => 1
        },
        {
            page_id   => 2,
            domain    => 'rejected.com',
            result    => undef,
            exception => 'Mirror cannot be added. Domain "rejected.com" rejected.',
        },
    ],
    'internal_search_on_site_campaign' => [
        {
            page_id   => 118826,
            domain    => 'approvedmirror.ru',
            exception => 'Mirror "approvedmirror.ru" already exists'
        },
        {
            page_id   => 118826,
            domain    => 'foo.approvedmirror.ru',
            exception => 'You should not add a subdomain as a mirror if a higher level domain is already added'
        },
        {
            page_id   => 'foobar',
            domain    => 'foo.bar',
            exception => 'Incorrect Page ID: "foobar"'
        },
        {
            page_id   => 118826,
            domain    => 'foo bar',
            exception => 'Invalid domain: "foo bar"'
        },
        {
            page_id => 118826,
            domain  => 'foo.bar',
            result  => 1
        },
        {
            page_id   => 118826,
            domain    => 'rejected.com',
            result    => undef,
            exception => 'Mirror cannot be added. Domain "rejected.com" rejected.',
        },
    ],
    'video_an_site' => [
        {
            page_id   => 154689,
            domain    => 'approvedmirror.ru',
            exception => 'Mirror "approvedmirror.ru" already exists'
        },
        {
            page_id   => 154689,
            domain    => 'foo.approvedmirror.ru',
            exception => 'You should not add a subdomain as a mirror if a higher level domain is already added'
        },
        {
            page_id   => 'foobar',
            domain    => 'foo.bar',
            exception => 'Incorrect Page ID: "foobar"'
        },
        {
            page_id   => 154689,
            domain    => 'foo bar',
            exception => 'Invalid domain: "foo bar"'
        },
        {
            page_id => 154689,
            domain  => 'foo.bar',
            result  => 1
        },
        {
            page_id   => 154689,
            domain    => 'rejected.com',
            result    => undef,
            exception => 'Mirror cannot be added. Domain "rejected.com" rejected.',
        },
    ],
};

run_tests(
    sub {
        my ($app) = @_;

        foreach my $accessor (sort keys %$fixture) {

            foreach my $fixture_data (@{$fixture->{$accessor}}) {

                my ($page_id, $domain, $result, $exception) = @$fixture_data{qw( page_id  domain  result  exception )};

                my $subtest = sprintf '%s: page_id=%s, domain=%s', $accessor, $page_id, $domain;
                subtest $subtest => sub {
                    note("Start $subtest");

                    my $got_res = undef;
                    eval {$got_res = $app->$accessor->mirrors->check($page_id, $domain)};

                    is($got_res, $result, 'result') if exists $fixture_data->{result};

                    my $got_exception = $@ ? $@->{text} : undef;
                    is($got_exception, $exception, 'got exception') if ($exception || $got_exception);
                  }
            }
        }

    }
);
