#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Fixture;
use qbit;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my $page         = get_fixture('partner_context_page_with_mirrors');
        my $page_model   = 'context_on_site_campaign';
        my $mirror_model = 'context_on_site_mirrors';

        my $new_mirror = $app->$mirror_model->get_all(fields => [qw(id)], filter => {multistate => '__EMPTY__'})->[0];
        my $rejected_mirror =
          $app->$mirror_model->get_all(fields => [qw(id)], filter => {multistate => 'rejected'})->[0];

        my $multistate_before = $app->$page_model->get($page, fields => [qw(multistate)])->{multistate};
        ok(!$app->$page_model->check_multistate_flag($multistate_before, 'need_update'), 'multistate before');

        $app->$mirror_model->do_action($rejected_mirror->{id}, 'approve');

        my $multistate_after_approve = $app->$page_model->get($page, fields => [qw(multistate)])->{multistate};
        ok($app->$page_model->check_multistate_flag($multistate_after_approve, 'need_update'),
            'multistate after approve');

        $app->partner_db->$page_model->edit($page, {multistate => $multistate_before});

        $app->$mirror_model->do_action($new_mirror->{id}, 'reject');

        my $multistate_after_reject = $app->$page_model->get($page, fields => [qw(multistate)])->{multistate};
        ok($app->$page_model->check_multistate_flag($multistate_after_reject, 'need_update'),
            'multistate after reject');
    },
    fill_databases => 0,
    fixtures       => [qw(partner_context_page_with_mirrors)],
);
