#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my %ignore = map {$_ => TRUE} qw(
          ssp_mobile_app_rtb
          context_on_site_stripe
          indoor_block
          outdoor_block
          ssp_context_on_site_rtb
          );

        foreach (@{$app->product_manager->get_block_model_names()}) {
            next if $ignore{$_};

            my $data = $app->$_->get_all(fields => [qw(editable_fields available_fields)], limit => 0)->[0];

            unless ($data) {
                note('No raws into table ' . $_);

                next;
            }

            cmp_deeply(
                $data,
                {
                    available_fields => superhashof({is_custom_bk_data => 1}),
                    editable_fields  => superhashof({is_custom_bk_data => 1}),
                },
                'check "bk_data" for manager, model: ' . $_
            );
        }
    },
    user => 'mocked-yan-manager'
);
