#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;

use qbit;

my $CAMP_ID = 148805;

run_tests(
    sub {
        my ($app) = @_;

        mock_format_system($app);

        my $MODELS = [
            {
                model      => 'context_on_site_adblock',
                public_id  => 'R-AB-153745-1',
                manager_id => '1015'
            },
        ];

        foreach (@$MODELS) {
            my $model      = $_->{'model'};
            my $public_id  = $_->{'public_id'};
            my $manager_id = $_->{'manager_id'};

            my $subtest_name = sprintf 'Model "%s" (%s)', $model, $public_id;
            subtest $subtest_name => sub {
                note 'Start ' . $subtest_name;

                @PiConstants::VIDEO_AWAPS_DSPS = (1);

                $app->{'__CURRENT_USER_RIGHTS__'} = {};
                $app->set_cur_user({id => $manager_id});

                $app->$model->do_action($public_id, 'edit', show_video => 0);
                $app->$model->do_action($public_id, 'edit', show_video => 1);
                is($app->$model->get($public_id, fields => [qw(show_video)])->{'show_video'},
                    1, "$model: set show_video");

                $app->$model->do_action($public_id, 'edit', is_custom_bk_data => 1,);

                is($app->$model->get($public_id, fields => [qw(is_custom_bk_data)])->{'is_custom_bk_data'},
                    1, "$model: set is_custom_bk_data");

                $app->$model->do_action($public_id, 'edit', is_custom_bk_data => 0);

                is($app->$model->get($public_id, fields => [qw(is_custom_bk_data)])->{'is_custom_bk_data'},
                    0, "$model: reset is_custom_bk_data");
              }
        }
    },
    mocks => {mock_bk_data_validator => TRUE}
);
