use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils;
use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2018-01-01 00:00:00');
        mock_news($app);
        mock_format_system($app);
        use_perl_get_all($app, 'context_on_site_rtb');            # missing video_active/video_blocked/video_cpm
        use_perl_get_all($app, 'internal_context_on_site_rtb');

        my $models =
          [@{$app->product_manager->get_page_model_accessors}, @{$app->product_manager->get_block_model_names}];

        foreach my $model (@$models) {
            next unless defined $app->$model->get_multistate_by_name('working');

            my $elems = $app->$model->get_all(fields => '*', filter => {multistate => 'working'});

            next unless @$elems;
            my $elem = $elems->[0];

            next unless %{$elem->{editable_fields}};

            my $editable_fields = $elem->{editable_fields};
            delete $editable_fields->{moderation};
            delete $editable_fields->{moneymap};
            my ($field) = grep {$_ eq 'caption' or $_ eq 'comment'} keys %$editable_fields;
            my %dsp_mode_auto = exists $editable_fields->{dsp_mode} ? ('dsp_mode' => 'auto') : ();

            $elem->{$field} = 'test';
            $app->$model->do_action($elem, 'edit', $field => $elem->{$field}, %dsp_mode_auto);

            my $elem_after_edit = $app->$model->get($elem, fields => [keys %$editable_fields]);

            map {delete $elem->{$_}} grep {not $editable_fields->{$_}} keys %$elem;
            $elem->{dsp_mode} = 'auto' if keys %dsp_mode_auto;

            cmp_deeply($elem_after_edit, $elem, "model $model edit fields");
        }
    }
);
