#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::MockObject::Extends;
use Test::Deep qw(cmp_deeply bag);

run_tests(
    sub {
        my ($app) = @_;

        $app->partner_db;
        $app->{partner_db} = Test::MockObject::Extends->new($app->{partner_db});

        cmp_deeply(
            $app->product_manager->get_page_model_accessors(),
            bag(
                'internal_context_on_site_campaign', 'internal_search_on_site_campaign',
                'search_on_site_campaign',           'context_on_site_campaign',
                'distribution_campaign',             'mobile_app_settings',
                'internal_mobile_app',               'video_an_site',
                'ssp_context_on_site_campaign',      'ssp_mobile_app_settings',
                'ssp_video_an_site',                 'indoor',
                'outdoor'
               ),
            "Right product list is gotten."
        );
    }
);
