use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Differences;

use qbit;

$ENV{LAZY_LOAD} = FALSE;

my @list_getters = qw(
  get_block_model_accessors
  get_page_model_accessors
  get_rtb_model_accessors
  get_site_model_accessors
  get_source_model_accessors
  get_statistics_accessors
  get_statistics_products

  get_external_product_accessors
  get_internal_product_accessors
  );

run_tests(
    sub {
        my ($app) = @_;

        my $product_manager = $app->product_manager;
        my $need_data       = {};
        my $has_data        = {};
        for my $getter (@list_getters) {
            $has_data->{$getter} = [sort @{$product_manager->$getter()}];
            $need_data->{$getter} = [sort @{eval "$getter(\$app)" // []}];
            throw $@ if $@;

            eq_or_diff($has_data->{$getter}, $need_data->{$getter}, $getter, {context => 1});
        }
    },
    do_not_die_on_fail   => 1,
    dont_create_database => TRUE,
);

sub get_statistics_accessors {
    my ($app) = @_;

    return [grep {$app->{$_}->isa('Application::Model::Statistics::Product')} get_accessors($app)];
}

sub get_statistics_products {
    my ($app) = @_;

    return [grep {!$app->{$_}->isa('Application::Model::Statistics::Hierarchy')} @{get_statistics_accessors($app)}];
}

sub get_site_model_accessors {
    my ($app) = @_;

    return [grep {$app->{$_}->isa('Application::Model::Page::Site')} get_accessors($app)];
}

sub get_source_model_accessors {
    [
        'distribution_campaign', 'indoor',  'internal_mobile_app', 'internal_site',
        'mobile_app',            'outdoor', 'site',                'ssp_application',
        'ssp_site',              'video_an_site'
    ];
}

sub get_block_model_accessors {
    [
        'context_on_site_adblock',          'context_on_site_content',
        'context_on_site_direct',           'context_on_site_market',
        'context_on_site_market_api',       'context_on_site_mcb',
        'context_on_site_rtb',              'context_on_site_stripe',
        'indoor_block',                     'internal_context_on_site_direct',
        'internal_context_on_site_rtb',     'internal_context_on_site_stripe',
        'internal_mobile_app_rtb',          'internal_search_on_site_direct',
        'internal_search_on_site_premium',  'mobile_app_rtb',
        'outdoor_block',                    'search_on_site_direct',
        'search_on_site_market',            'search_on_site_market_api',
        'search_on_site_mcb',               'search_on_site_premium',
        'ssp_context_on_site_rtb',          'ssp_mobile_app_rtb',
        'ssp_video_an_site_rtb',            'video_an_site_fullscreen',
        'video_an_site_inpage',             'video_an_site_instream',
        'internal_context_on_site_content', 'context_on_site_natural',
        'internal_context_on_site_natural',
    ];
}

sub get_rtb_model_accessors {
    my ($app) = @_;

    return [
        'context_on_site_adblock',
        grep {Role::Tiny::does_role($app->{$_}, 'Application::Model::Role::Has::RTB')} get_accessors($app)
    ];
}

sub get_page_model_accessors {
    my ($app) = @_;

    return [grep {$app->{$_}->isa('Application::Model::PageMinimal')} get_accessors($app)];
}

sub get_external_product_accessors {
    my ($app) = @_;

    return [grep {$app->$_->is_external_page()} @{get_page_model_accessors($app)}];
}

sub get_internal_product_accessors {
    my ($app) = @_;

    return [grep {$app->$_->is_internal_page()} @{get_page_model_accessors($app)}];
}

sub get_accessors {
    my ($app) = @_;

    return grep {blessed($app->{$_})} keys %{$app};
}
