#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore);
use Test::More;
use Test::Exception;

run_tests(
    sub {
        my ($app) = @_;

        my $fixture = {
            'R-A-41443-1' => {
                accessor  => 'context_on_site_rtb',
                public_id => 'R-A-41443-1'
            },
            'S-A-41443-40' => {
                accessor  => 'context_on_site_stripe',
                public_id => 'S-A-41443-40'
            },
            'P-A-111161-2' => {
                accessor  => 'search_on_site_premium',
                public_id => 'P-A-111161-2'
            },
            'R-M-43569-1' => {
                accessor  => 'mobile_app_rtb',
                public_id => 'R-M-43569-1'
            },
            'R-V-128972-1' => {
                accessor  => 'video_an_site_instream',
                public_id => 'R-V-128972-1'
            },
            'R-VI-154689-1' => {
                accessor  => 'video_an_site_inpage',
                public_id => 'R-VI-154689-1'
            },
            'R-I-88848-1' => {
                accessor  => 'internal_context_on_site_rtb',
                public_id => 'R-I-88848-1'
            },
            'S-I-148805-1' => {
                accessor  => 'internal_context_on_site_stripe',
                public_id => 'S-I-148805-1'
            },
            'P-I-128843-1' => {
                accessor  => 'internal_search_on_site_premium',
                public_id => 'P-I-128843-1'
            },
            'R-IM-132439-1' => {
                accessor  => 'internal_mobile_app_rtb',
                public_id => 'R-IM-132439-1'
            },
            # D-A-
            'D-A-142898-2' => {
                accessor  => 'context_on_site_direct',
                public_id => 'D-A-142898-2'
            },
            'D-A-111161-1' => {
                accessor  => 'search_on_site_direct',
                public_id => 'D-A-111161-1'
            },
            # D-I-
            'D-I-88849-1' => {
                accessor  => 'internal_context_on_site_direct',
                public_id => 'D-I-88849-1'
            },
            '88849-1' => {
                accessor  => 'internal_context_on_site_direct',
                public_id => '88849-1'
            },
            'D-I-118826-1' => {
                accessor  => 'internal_search_on_site_direct',
                public_id => 'D-I-118826-1'
            },
            # zero
            'D-A-127137-0' => {
                error         => 'no_data_for_zero_block',
                error_message => gettext('No info for zero block'),
            },
        };
        foreach my $public_id (keys %$fixture) {
            is_deeply($app->product_manager->get_model_data_from_public_id($public_id, FALSE),
                $fixture->{$public_id}, $public_id);
        }

        # Direct -> RTB  (#PI-10318)
        my $fixture_relaxed = {
            'D-A-41443-1' => {
                accessor  => 'context_on_site_rtb',
                public_id => 'R-A-41443-1'
            },
        };
        foreach my $public_id (keys %$fixture_relaxed) {
            is_deeply(
                $app->product_manager->get_model_data_from_public_id($public_id, TRUE),
                $fixture_relaxed->{$public_id},
                $public_id . ' relaxed'
            );
        }

        dies_ok(
            sub {
                $app->product_manager->get_model_data_from_public_id('NO-SUCH-PUBLIC-ID-132439-1')->{'accessor'};
            },
            'Unknown public_id'
        );

        dies_ok(
            sub {
                $app->product_manager->get_model_data_from_public_id('D-I-88848-1')->{'accessor'};
            },
            'Unknown public_id'
        );
    },
    application_package => 'Rosetta',
    user                => 'yndx-bessarabov',

);

__END__
