#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

$ENV{'LAZY_LOAD'} = FALSE;

my $fixture = {
    'get_product_structure by login'   => {filter => {'login'   => 'mocked-yan-partner'},},
    'get_product_structure by page_id' => {filter => {'page_id' => 142898},},
    'get_product_structure by domain'               => {filter => {'domain', 'showmethemoney.ru'},},
    'get_product_structure by domain with "www."'   => {filter => {'domain', 'www.showmethemoney.ru'},},
    'get_product_structure by domain with protocol' => {filter => {'domain', 'http://showmethemoney.ru'},},
    'get_product_structure by domain with staff after domain zone' =>
      {filter => {'domain', 'showmethemoney.ru/bla/bla'},},
    'get_product_structure by both with and without "www." prefix domains' => {
        filter => {'domain', 'protected.com'},
        size   => 4,
    },
    'get_product_structure by domain with protocol, "www." and staff after domain zone' =>
      {filter => {'domain', 'https://www.showmethemoney.ru/bla.bla/bla/?bla=bla#bla'},},
    'get_product_structure by client_id'   => {filter => {'client_id',   11009},},
    'get_product_structure by pi_id'       => {filter => {'pi_id',       300},},
    'get_product_structure by adfox_login' => {filter => {'adfox_login', 'adfox_login_1'},},
    'zget_product_structure by bundle_id'  => {
        cur_user => 1011,
        filter   => {'bundle_id', 'app.test.com'},
    },
};

run_tests(
    sub {
        my ($app) = @_;

        my $structure = array_each(
            superhashof(
                {
                    login    => re(qr(\w)),
                    products => array_each(
                        superhashof(
                            {
                                name     => re(qr(\w)),
                                model    => re(qr(\w)),
                                products => array_each(
                                    superhashof(
                                        {
                                            page_id    => re(qr(\d)),
                                            domain     => re(qr(\w)),
                                            is_deleted => re(qr(^1|$)),
                                            products   => array_each(
                                                superhashof(
                                                    {
                                                        count => re(qr(\d)),
                                                        model => re(qr(\w)),
                                                    }
                                                )
                                            )
                                        }
                                    )
                                )
                            }
                        )
                    )
                }
            )
        );

        foreach my $testname (sort keys %$fixture) {
            my ($filter, $cur_user, $size) = @{$fixture->{$testname}}{qw( filter  cur_user  size )};

            subtest $testname => sub {
                my $data = $app->product_manager->get_product_structure(%$filter);

                $app->set_cur_user({id => $cur_user}) if $cur_user;

                if (defined $size) {
                    ok(@$data == $size, 'data length');
                } else {
                    ok(@$data, 'data is not empty');
                }

                cmp_deeply($data, $structure, 'structure');
              }
        }

    },
    user => 'mocked-yan-manager',
);
