#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $data = [
            # РЕКЛАМА НА САЙТАХ
            {
                testname => 'РЕКЛАМА НА САЙТАХ. Тематические площадки - with Adfox',
                accessor => 'context_on_site_campaign',
                login    => 'mocked-yan-partner',
                id       => 1,
                with_adfox => 1,
            },
            {
                testname =>
                  'РЕКЛАМА НА САЙТАХ. Тематические площадки - without Adfox',
                accessor   => 'context_on_site_campaign',
                login      => 'mocked-video-partner',
                id         => 801,
                with_adfox => 0,
            },
            {
                testname =>
                  'РЕКЛАМА НА САЙТАХ. Тематические площадки - with Adblock',
                accessor     => 'context_on_site_campaign',
                login        => 'mocked-context-adblock-partner',
                id           => 153745,
                with_adfox   => 0,
                with_adblock => 1,
            },
            {
                testname => 'РЕКЛАМА НА САЙТАХ. Поисковые площадки',
                accessor => 'search_on_site_campaign',
                login    => 'mocked-yan-partner',
                id       => 111161,
            },

            # РЕКЛАМА В ПРИЛОЖЕНИЯХ
            {
                testname => 'РЕКЛАМА В ПРИЛОЖЕНИЯХ. Приложения',
                accessor => 'mobile_app_settings',
                login    => 'mocked-mobile-app-partner',
                id       => 43569
            },

            # РЕКЛАМА В ВИДЕО
            {
                testname => 'РЕКЛАМА В ВИДЕО. Ресурсы',
                accessor => 'video_an_site',
                login    => 'mocked-video-partner',
                id       => 128972,
                expect   => ['video_an_site_instream'],
            },

            # СЕРВИСЫ ЯНДЕКСА
            {
                testname => 'СЕРВИСЫ ЯНДЕКСА. Тематические площадки',
                accessor => 'internal_context_on_site_campaign',
                login    => 'mocked-internal-manager',
                id       => 2
            },
            {
                testname => 'СЕРВИСЫ ЯНДЕКСА. Поисковые площадки',
                accessor => 'internal_search_on_site_campaign',
                login    => 'mocked-internal-manager',
                id       => 118826
            },
            {
                testname => 'СЕРВИСЫ ЯНДЕКСА. Приложения',
                accessor => 'internal_mobile_app',
                login    => 'mocked-internal-manager',
                id       => 132439
            },

        ];

        #########
        foreach my $testdata (@$data) {

            my ($login, $accessor, $id, $with_adfox, $with_adblock, $testname, $expect) =
              @$testdata{qw(login  accessor  id  with_adfox  with_adblock testname expect)};

            change_cur_user($app, $login);

            my $all_block_model_names = $app->$accessor->get_block_model_names();
            $expect //=
                $with_adfox || !defined($with_adfox)
              ? $all_block_model_names
              : [grep {$_ !~ /adfox$/} @$all_block_model_names];

            $expect = [grep {$_ !~ /adblock$/} @$expect] unless $with_adblock;

            subtest(
                $testname . '(' . $accessor . ')' => sub {
                    # With rights for all blocks
                    {
                        # Add "*_add" rights
                        my $tmp_rights = $app->add_tmp_rights(map {'do_' . $_ . '_add'} @$all_block_model_names);

                        my $got = $app->$accessor->get($id, fields => [qw(available_blocks)]);

                        cmp_deeply($got->{available_blocks}, $expect, 'All rights');
                    }

                    # With right for only one block
                    {
                        my $curr_rights = $app->{'__CURRENT_USER_RIGHTS__'};

                        # Revoke all '*_add' rights
                        map {delete $curr_rights->{'do_' . $_ . '_add'}} @$all_block_model_names;

                        # Add right for the first block only
                        my $first_block_name = $expect->[0];
                        my $tmp_rights       = $app->add_tmp_rights('do_' . $first_block_name . '_add');

                        my $got = $app->$accessor->get($id, fields => [qw(available_blocks)]);

                        cmp_deeply($got->{available_blocks}, [$first_block_name], 'Only one right');
                    }
                }
            );
        }

        ########

    },
    reuse_database => 1
);
