#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

my $DOMAIN = 'mirror.com';

my $DATA = [
    # РЕКЛАМА НА САЙТАХ – Проверка реализована в тестах на зеркала

    # РЕКЛАМА В ПРИЛОЖЕНИЯХ - зеркала отсутствуют (mobile_app_settings)

    # РЕКЛАМА В ВИДЕО
    {
        testname => 'РЕКЛАМА В ВИДЕО. Ресурсы',
        model    => 'video_an_site',
        login    => 'mocked-video-partner',
        success  => FALSE,
        id       => 128972
    },
    {
        testname => 'РЕКЛАМА В ВИДЕО. Ресурсы',
        model    => 'video_an_site',
        login    => 'tutby-cop',
        success  => FALSE,
        id       => 154690
    },

    # СЕРВИСЫ ЯНДЕКСА
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Тематические площадки',
        model    => 'internal_context_on_site_campaign',
        login    => 'mocked-internal-administrator',
        success  => TRUE,
        id       => 2
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Поисковые площадки',
        model    => 'internal_search_on_site_campaign',
        login    => 'mocked-internal-administrator',
        success  => TRUE,
        id       => 118826
    },
    # ПРИЛОЖЕНИЯ - зеркала отсутствуют (internal_mobile_app)

];

run_tests(
    sub {
        my ($app) = @_;

        #########
        foreach my $testdata (@$DATA) {

            my ($login, $model, $id, $testname, $success) = @$testdata{qw( login  model  id  testname success)};

            change_cur_user($app, $login);

            # Во внутренних площадках пока не реализован "need_update"
            next
              unless $app->$model->get_registered_actions()->{'set_need_update'}
                  || $app->$model->get_registered_actions_rights()->{'set_need_update'};

            subtest(
                "$testname (id=$id)" => sub {

                    my $error;
                    my $message;
                    # Добавлем зеркало, проверяем флаг "need_update" на площдке
                    try {
                        _add_mirror($app, $model, $id, $DOMAIN);
                        _check_page_flag_need_update($app, $model, $id, TRUE);
                    }
                    catch {
                        $error   = $@;
                        $message = $@->message;
                    };

                    if ($success) {
                        ok(!$error, 'Adding miror and check need_update');
                    } else {

                        is($message, 'You can not edit the following fields: mirrors', 'Error message is correct');
                    }

                    $message = $error = undef;

                    # Тоже самое с удаленной площадкой
                    {
                        $app->$model->maybe_do_action({id => $id}, 'stop');
                        $app->$model->do_action({id => $id}, 'delete');

                        try {
                            _add_mirror($app, $model, $id, $DOMAIN . '.net');
                        }
                        catch {
                            $error   = $@;
                            $message = $@->message;
                        };

                        my $multiistate = $app->$model->get($id, fields => ['multistate'])->{'multistate'};

                        is(ref($error), 'Exception::Multistate::BadAction', 'Exception name correct');

                        my $action = 'edit';
                        my $pk = sprintf('"%d"', $id);
                        $message =~ s/, action.*$//;
                        $message .= ').';
                        is(
                            $message,
                            sprintf(
                                'Cannot do action "%s" (login "%s", multistate %s, pk %s, model "%s").',
                                $action, $login, $multiistate, $pk, $model
                            ),
                          );
                    }
                },
                locale => 'C'
            );
        }

        ########

    },
    mocks => ['mock_zora']
);

sub _add_mirror {
    my ($app, $model, $id, $domain) = @_;
    $domain //= $DOMAIN;
    $app->add_tmp_rights('add_mirrors_without_moderation');
    $app->$model->do_action($id, 'edit', mirrors => [$domain]);
}

sub _check_page_flag_need_update {
    my $app    = shift;
    my $model  = shift;
    my $id     = shift;
    my $expect = shift || FALSE;

    my $expect_status = 'need_update';

    my $object = $app->$model->get($id, fields => [qw( page_id  multistate )]);
    my ($page_id, $multiistate) = @$object{qw( page_id  multistate )};

    my $got = $app->$model->check_multistate_flag($multiistate, $expect_status);

    my $no = $expect ? 'got' : 'has no';
    is(
        $got, $expect,
        sprintf(
            'page_id=%s (%s) %s multistate=%d with state "%s"', $page_id, $model, $no, $multiistate, $expect_status
        )
      );
}
