#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_bk);

use Test::More;
use Test::Deep;

use qbit;

my $DATA = [
    # РЕКЛАМА НА САЙТАХ
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Тематические площадки',
        model    => 'context_on_site_campaign',
        login    => 'mocked-yan-partner',
        id       => 1,
        status   => 'working and not (blocked or protected or read_only or rejected or deleted or need_approve)',
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Поисковые площадки',
        model    => 'search_on_site_campaign',
        login    => 'mocked-yan-partner',
        id       => 111161,
        status   => 'working and not (blocked or protected or read_only or rejected or deleted or need_approve)',
    },

    # РЕКЛАМА В ПРИЛОЖЕНИЯХ
    {
        testname => 'РЕКЛАМА В ПРИЛОЖЕНИЯХ. Приложения',
        model    => 'mobile_app_settings',
        login    => 'mocked-mobile-app-partner',
        id       => 43569,
        status   => 'working and not (blocked or protected or rejected or deleted or need_approve)'
    },

    # РЕКЛАМА В ВИДЕО
    {
        testname => 'РЕКЛАМА В ВИДЕО. Ресурсы',
        model    => 'video_an_site',
        login    => 'mocked-video-partner',
        id       => 128972,
        status   => 'working and not (protected or deleted)'
    },

    # СЕРВИСЫ ЯНДЕКСА
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Тематические площадки',
        model    => 'internal_context_on_site_campaign',
        login    => 'mocked-internal-manager',
        id       => 2,
        status   => 'working and not (protected or read_only or deleted or stopped)',
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Поисковые площадки',
        model    => 'internal_search_on_site_campaign',
        login    => 'mocked-internal-manager',
        id       => 118826,
        status   => 'working and not (protected or read_only or deleted or stopped)',
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Приложения',
        model    => 'internal_mobile_app',
        login    => 'mocked-internal-manager',
        id       => 132439,
        status   => 'working and not (protected or deleted or stopped)',
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);

        #########
        foreach my $testdata (@$DATA) {
            my ($login, $model, $id, $testname) = @$testdata{qw( login  model  id  testname )};

            change_cur_user($app, $testdata->{'login'});

            subtest(
                $testname => sub {

                    # Проверяем обычную отправку
                    _check_status($app, $testdata, ['set_need_update']);

                    # Проверяем отправку удаленной площадки
                    _check_status($app, $testdata, ['set_need_update', 'stop', 'delete']);

                    # Проверяем переотправку в случае если если что-то пошло не так
                    _check_status($app, $testdata, ['set_need_update', 'stop', 'delete', 'start_update']);
                }
            );
        }

        ########

    },
    do_not_die_on_fail => 1
);

sub _check_status {
    my ($app, $testdata, $set_statuses) = @_;

    my $id    = $testdata->{'id'};
    my $model = $testdata->{'model'};

    # Чтобы не было проблем с графом статусов
    $app->partner_db->$model->edit($id,
        {multistate => $app->$model->get_multistates_by_filter($testdata->{'status'})->[0]});

    # Подводим к нужному статусу
    my $tmp_rights = $app->add_all_tmp_rights();
    foreach (@$set_statuses) {
        if ($_ eq 'start_update') {
            my $bits_hs = $app->$model->get_multistates_bits_hs();

            my $multistate = $app->partner_db->$model->get($id, fields => ['multistate'])->{'multistate'};
            $multistate |= 2**$bits_hs->{'updating'}{'bit'};

            $app->partner_db->$model->edit($id, {multistate => $multistate});
        } else {
            $app->$model->do_action($id, $_);
        }
    }

    # Отправлем в БК
    $app->$model->update_in_bk({id => $id});

    # Проверяем отсутствие флага 'need_update'
    _check_multistate($app, $model, $id, $set_statuses->[-1], FALSE);
}

sub _check_multistate {
    my ($app, $model, $id, $after_action, $expect) = @_;

    my $expect_status = 'need_update';

    # Проверяем статус
    my $multiistate = $app->$model->get($id, fields => ['multistate'])->{'multistate'};
    my $got = $app->$model->check_multistate_flag($multiistate, $expect_status);

    my $no = $expect ? 'got' : 'has no';
    is(
        $got, $expect,
        sprintf(
            'id=%s, multistate=%d (%s) %s flag "%s" after action "%s"',
            $id, $multiistate, $model, $no, $expect_status, $after_action
        )
      );

}
