use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More tests => 3;
use qbit;

# TODO - нужно поправить данные в mocked_databases и убрать эти исключения
my %IGNORE = map {$_ => 1} qw(
  block_tags
  business_rules
  context_on_site_direct
  indoor
  indoor_block
  internal_context_on_site_direct
  internal_search_on_site_direct
  internal_search_on_site_premium
  ssp_application
  statistics_reports
  users
  video_an_site_fullscreen
  video_an_site_inpage
  );

run_tests(
    sub {
        my ($app) = @_;

        mock_balance($app);
        mock_news($app);

        subtest 'check all elements in model' => sub {
            my @names = $app->qbit_validator_checker->get_model_names_that_use_qbit_validator();

            plan tests => scalar(@names) - scalar(keys %IGNORE);

            my $count = 0;
            foreach my $accessor (@names) {
                next if $IGNORE{$accessor};
                subtest $accessor => sub {
                    _check_model($app, $accessor, 'all',       undef, undef, 0);
                    _check_model($app, $accessor, 'every_nth', undef, 3,     0);
                    _check_model($app, $accessor, 'page_ids', [153745], 3, 0);
                  }
            }
          }
    },
    do_not_die_on_fail => 1,
);

sub _check_model {
    my ($app, $accessor, $name, $page_ids, $reminder_of_division, $random_start_posision) = @_;

    my ($is_ok, $details) = $app->qbit_validator_checker->check_all_elements_in_model(
        accessor              => $accessor,
        page_ids              => $page_ids,
        step                  => $reminder_of_division,
        random_start_position => $random_start_posision
    );

    if ($is_ok) {
        pass($name);
    } else {
        fail($name);
        Test::More::diag(to_json($details, pretty => 1));
    }
}
