#!/usr/bin/perl

use Test::More tests => 1 + 2;
use Test::Differences qw(eq_or_diff);

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Partner2::Juggler::API;

my $CRON_PATH = 'system';

run_tests(
    sub {
        my ($app) = @_;

        $app->set_option('stage' => 'production');

        my $api_juggler = $app->get_option('api_juggler');

        my $pja = Partner2::Juggler::API->new(
            juggler_token => 'juggler-token',
            host          => $api_juggler->{'host'},
            namespace     => $api_juggler->{'namespace'},
        );

        my @checks         = ();
        my @juggler_models = ();
        my @cron_models    = ('aggregator');
        mock_subs(
            {
                'Cron::INFO'                                            => sub { },
                'QBit::Cron::INFO'                                      => sub { },
                'Cron::Methods::System::generate_models_and_validation' => sub {
                    my ($self, %opts) = @_;

                    push @cron_models,
                      map {$opts{instances} ? $_ . '_' . $opts{instance_number} : $_} @{$opts{accessors}};
                },
                'Partner2::Juggler::API::add_or_update' => sub {
                    my ($self, %opts) = @_;

                    push(@checks, \%opts);

                    my $service = $opts{service};
                    $service =~ s/^qbit_validator\.//;
                    push @juggler_models, $service;
                },
            }
        );

        $app->qbit_validator_checker->generate_juggler($pja);

        my $expected = get_test_data_and_update_if_needed('checks.json', \@checks);

        eq_or_diff(\@checks, $expected, 'checks');

        my $methods = $app->get_cron_methods()->{$CRON_PATH};
        foreach my $method (keys %$methods) {
            next if $method !~ /^run_qbit_validator_checks_/;
            my $attrs = $methods->{$method}{attrs};
            foreach my $i (1 .. ($attrs->{instances} // 1)) {
                my $full_method = $attrs->{instances} ? $method . '_' . $i : $method;
                $app->do($CRON_PATH, $full_method);
            }
        }

        eq_or_diff([sort @juggler_models], [sort @cron_models], 'models');
    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1,
    application_package  => 'Cron',
);
