use qbit;

use Data::Rmap qw(rmap_hash);
use Test::Differences;
use Test::More;
use Test::Partner2::Mock;
use Test::Partner2::Simple;
use Test::Partner2::Fixture;
use Test::Partner::Utils;

use Test::Partner2::Support::Common;

use PiConstants qw($IS_PRECISE);

my @fixtures = (
    'user_cron',
    'mocked_yan_manager',
    'mocked_yan_partner',
    'tns_dict_brand',

    'partner_context_vip_page',
    'partner_context_page',
    'partner_mobile_page',

    'partner_context_rtb_block',
    'partner_context_rtb_block_with_mincpm_strategy',
    'partner_context_rtb_block_with_blocked_brands',
    'partner_context_rtb_vip_block',

    'partner_mobile_native_rtb_block_with_custom_bk_data',
    'partner_mobile_banner_rtb_block',
);

run_tests(
    sub {
        my ($app) = @_;

        use_common_blocks_table($app);

        my %process = $app->support->get_object('change_blocked_brands')->make_process($app);
        my $test    = new Test::Partner2::Support::Common(
            type   => 'cron',
            app    => $app,
            save   => $process{save},
            result => sub {
                my ($app, %opts) = @_;
                return $app->partner_db->brands->get_all();
            },
            clear => sub {
                my ($app, %opts) = @_;
                $app->partner_db->brands->delete($app->partner_db->filter(\1));
            }
        );

        $test->prepare;

        my $block_sample = $app->context_on_site_rtb->get(get_fixture('partner_context_rtb_block_with_blocked_brands'),
            fields => ['public_id'])->{public_id};
        my $block_target =
          $app->context_on_site_rtb->get(get_fixture('partner_context_rtb_vip_block'), fields => ['public_id'])
          ->{public_id};

        $test->push_data('init brands', $app->partner_db->brands->get_all());

        $test->make_all_tests(
            [
                {
                    title => 'validation: no data',
                    form  => {},
                    error => qr/Exception::Form: You must enter one of target: Logins, Page IDs, Block IDs/,
                },
                {
                    title => 'validation: no destination blocks',
                    form  => {
                        blocks       => 'R-A-100-100,D-A-100-100',
                        sample       => $block_sample,
                        ticket       => 'PI-100000',
                        apply_method => 'update',
                        apply_gm     => 1,
                    },
                    error => qr/Exception::Form: Has invalid entry in Block IDs: R-A-100-100, D-A-100-100/,
                },
                {
                    title => 'validation: no sample block',
                    form  => {
                        pages        => get_fixture('partner_mobile_page')->{context_page_id},
                        sample       => 'R-A-100-100',
                        ticket       => 'PI-100000',
                        apply_method => 'update',
                        apply_gm     => 1,
                    },
                    error => qr/Exception::Form: No valid Sample block/,
                },
                {
                    title => 'set on page by sample',
                    form  => {
                        pages        => get_fixture('partner_mobile_page')->{context_page_id},
                        sample       => $block_sample,
                        ticket       => 'PI-100000',
                        apply_method => 'update',
                        apply_gm     => 1,
                    },
                    extra => sub {
                        my ($app) = @_;
                        return $app->mobile_app_rtb->get_all(
                            fields => ["bk_data"],
                            filter => {is_custom_bk_data => 1}
                        );
                    },
                },
                {
                    title => 'set on block by bid',
                    form  => {
                        blocks       => $block_target,
                        brands       => '420',
                        ticket       => 'PI-100000',
                        apply_method => 'update',
                    },
                    clear => 1,
                },
                {
                    title => 'set on login by bid',
                    form  => {
                        logins       => 'mocked-yan-partner',
                        brands       => '647',
                        ticket       => 'PI-100000',
                        apply_method => 'update',
                    },
                    clear => 1
                },
                {
                    title => 'add on login by bid',
                    form  => {
                        logins       => 'mocked-yan-partner',
                        brands       => '420',
                        ticket       => 'PI-100000',
                        apply_method => 'add',
                    }
                },
                {
                    clear => 1,
                    title => 'set on login with add on clean',
                    form  => {
                        pages        => get_fixture('partner_mobile_page')->{context_page_id},
                        brands       => '420',
                        ticket       => 'PI-100000',
                        apply_method => 'add',
                        apply_gm     => 1,
                    },
                    extra => sub {
                        my ($app) = @_;
                        return $app->mobile_app_rtb->get_all(
                            fields => ["bk_data"],
                            filter => {is_custom_bk_data => 1}
                        );
                    },
                },
                {
                    title => 'set on login with replace',
                    form  => {
                        pages        => get_fixture('partner_mobile_page')->{context_page_id},
                        brands       => '647',
                        ticket       => 'PI-100000',
                        apply_method => 'replace',
                        apply_gm     => 1,
                    },
                    extra => sub {
                        my ($app) = @_;
                        return $app->mobile_app_rtb->get_all(
                            fields => ["bk_data"],
                            filter => {is_custom_bk_data => 1}
                        );
                    },
                },
            ]
        );

        my $expected = get_test_data_and_update_if_needed('data.json', $test->{data});
        if ($IS_PRECISE) {
            my $fix_data_sub = sub {
                my ($el) = @_;
                my @fields_to_num =
                  qw(bid block_id blocked current_user id multistate page_id page_multistate plain_text_wrapper user_id);
                map {$el->{$_} += 0}
                  grep {defined $el->{$_}} @fields_to_num;
                if (defined $el->{brand_list}) {
                    map {$_ += 0} @{$el->{brand_list}};
                }
                foreach my $key (qw(comment message_body)) {
                    if (defined $el->{$key}) {
                        foreach my $subkey (@fields_to_num) {
                            $el->{$key} =~ s/("$subkey" : )"(\d+)"/$1$2/g;
                        }
                    }
                }
                return $el;
            };
            rmap_hash {$fix_data_sub->($_)} @{$test->{data}};
            rmap_hash {$fix_data_sub->($_)} @$expected;
        }
        eq_or_diff(from_json(to_json($test->{data})), $expected, 'compare', {context => 10});
    },
    fixtures            => \@fixtures,
    fill_databases      => 0,
    application_package => 'Cron',
    init                => ['mail_notification', 'startrek', 'support']
);
