use qbit;

use Data::Rmap qw(rmap_hash);
use Test::Differences;
use Test::More;
use Test::Partner2::Mock;
use Test::Partner2::Simple;
use Test::Partner2::Fixture;
use Test::Partner::Utils;

use Utils::PublicID;

use Test::Partner2::Support::Common;

use PiConstants qw($IS_PRECISE);

my @fixtures = (
    'user_cron',
    'mocked_yan_manager',
    'mocked_yan_partner',
    'mocked_mobile_app_partner',

    'partner_context_page',
    'partner_indoor_page',
    'partner_mobile_page',

    'partner_context_rtb_block',
    'partner_context_rtb_block_with_mincpm_strategy',

    'partner_indoor_video_block_with_custom_bk_data',
    'partner_indoor_video_block',

    'partner_mobile_native_rtb_block_with_custom_bk_data',
    'partner_mobile_native_rtb_block',
    'partner_mobile_banner_rtb_block',

    'dsp_nonmoder',

    'tns_dict_article',
    'picategories_dict',
    'feature_vmap_for_mocked_video_partner',
);

my $last_dsp_data;

run_tests(
    sub {
        my ($app) = @_;

        use_common_blocks_table($app);

        my $dsp_nonmoder = get_fixture('dsp_nonmoder')->{id};

        my $partner_context_page = get_fixture('partner_context_page')->{page_id};
        my $partner_context_rtb_block =
          $app->context_on_site_rtb->get(get_fixture('partner_context_rtb_block'), fields => ['public_id'])
          ->{public_id};
        my $partner_context_rtb_block_with_mincpm_strategy =
          $app->context_on_site_rtb->get(get_fixture('partner_context_rtb_block_with_mincpm_strategy'),
            fields => ['public_id'])->{public_id};

        my $partner_mobile_native_rtb_block_with_custom_bk_data =
          $app->mobile_app_rtb->get(get_fixture('partner_mobile_native_rtb_block_with_custom_bk_data'),
            fields => ['public_id'])->{public_id};
        my $partner_mobile_banner_rtb_block =
          $app->mobile_app_rtb->get(get_fixture('partner_mobile_banner_rtb_block'), fields => ['public_id'])
          ->{public_id};
        my $partner_mobile_native_rtb_block =
          $app->mobile_app_rtb->get(get_fixture('partner_mobile_native_rtb_block'), fields => ['public_id'])
          ->{public_id};

        my $partner_indoor_video_block_with_custom_bk_data =
          $app->indoor_block->get(get_fixture('partner_indoor_video_block_with_custom_bk_data'),
            fields => ['public_id'])->{public_id};
        my $partner_indoor_video_block =
          $app->indoor_block->get(get_fixture('partner_indoor_video_block'), fields => ['public_id'])->{public_id};

        my %process = $app->support->get_object('turn_on_unmoderate_dsp')->make_process($app);
        my $test    = new Test::Partner2::Support::Common(
            type   => 'cron',
            app    => $app,
            save   => $process{save},
            result => \&get_dsp_data,
        );

        $test->prepare;

        $test->push_data('orig block_dsps', get_dsp_data($app));

        my $all_tests = [
            {
                title => 'validation: no data',
                form  => {},
                error => qr/Exception::Form: You must enter one of target: Logins, Page IDs, Block IDs/,
            },
            {
                title => 'validation: no list dsp',
                form  => {
                    blocks => $partner_context_rtb_block,
                    ticket => 'PI-100000',
                },
                error => qr/Exception::Form: You must enter one of source: Unmoderated DSP IDs/,
            },
            {
                title => 'validation: no ticket',
                form  => {
                    blocks          => $partner_context_rtb_block,
                    unmoderated_dsp => $dsp_nonmoder,
                },
                error => qr/Exception::Form: Has invalid entry in Origin ticket: No valid ticket/,
            },
            {
                title => 'set on block rtb',
                form  => {
                    blocks          => $partner_context_rtb_block,
                    unmoderated_dsp => $dsp_nonmoder,
                    ticket          => 'PI-100000',
                },
                extra => sub {
                    my ($app) = @_;
                    return +{partner_context_rtb_block =>
                          filtered_block_bk_data($app->context_on_site_rtb, $partner_context_rtb_block)
                    };
                },
            },
            {
                title => 'cannot set on block indoor',
                form  => {
                    blocks          => $partner_indoor_video_block,
                    unmoderated_dsp => $dsp_nonmoder,
                    ticket          => 'PI-100000',
                },
                error => qr/Exception::Form: Has invalid entry in Block IDs: I-D-\d+-\d+/,
            },
            {
                title => 'set on block mobile native',
                form  => {
                    blocks          => $partner_mobile_native_rtb_block,
                    unmoderated_dsp => $dsp_nonmoder,
                    ticket          => 'PI-100000',
                },
                error => qr/Exception::Form: Has invalid entry in Block IDs: R-M-\d+-\d+/,
            },
            {
                title => 'set on block mobile',
                form  => {
                    blocks          => $partner_mobile_banner_rtb_block,
                    unmoderated_dsp => $dsp_nonmoder,
                    ticket          => 'PI-100000',
                },
                extra => sub {
                    my ($app) = @_;
                    return +{partner_mobile_banner_rtb_block =>
                          filtered_block_bk_data($app->mobile_app_rtb, $partner_mobile_banner_rtb_block),
                    };
                },
            },
            {
                title => 'set on login',
                form  => {
                    logins          => 'mocked-mobile-app-partner',
                    unmoderated_dsp => $dsp_nonmoder,
                    ticket          => 'PI-100000',
                    apply_gm        => 1,
                },
                extra => sub {
                    my ($app) = @_;
                    return +{
                        partner_mobile_banner_rtb_block =>
                          filtered_block_bk_data($app->mobile_app_rtb, $partner_mobile_banner_rtb_block),
                        partner_mobile_native_rtb_block_with_custom_bk_data => filtered_block_bk_data(
                            $app->mobile_app_rtb, $partner_mobile_native_rtb_block_with_custom_bk_data
                        )
                    };
                },
            },
            {
                title => 'set on page',
                form  => {
                    pages           => $partner_context_page,
                    unmoderated_dsp => $dsp_nonmoder,
                    ticket          => 'PI-100000',
                },
                extra => sub {
                    my ($app) = @_;
                    return +{
                        partner_context_rtb_block_with_mincpm_strategy => filtered_block_bk_data(
                            $app->context_on_site_rtb, $partner_context_rtb_block_with_mincpm_strategy
                        )
                    };
                },
            }
        ];

        $test->make_all_tests($all_tests);

        my $expected = get_test_data_and_update_if_needed('data.json', $test->{data});
        if ($IS_PRECISE) {
            my $fix_data_sub = sub {
                my ($el) = @_;
                my @fields_to_num =
                  qw(block_id context_page_id current_user is_deleted multistate page_id page_id page_multistate plain_text_wrapper unmoderated_dsp unmoderated_rtb_auction user_id);
                map {$el->{$_} += 0}
                  grep {defined $el->{$_}} @fields_to_num;
                if (defined $el->{brand_list}) {
                    map {$_ += 0} @{$el->{brand_list}};
                }
                foreach my $key (qw(comment message_body)) {
                    if (defined $el->{$key}) {
                        foreach my $subkey (@fields_to_num) {
                            $el->{$key} =~ s/("$subkey" : )"(\d+)"/$1$2/g;
                        }
                    }
                }
                return $el;
            };
            rmap_hash {$fix_data_sub->($_)} @{$test->{data}};
            rmap_hash {$fix_data_sub->($_)} @$expected;
        }
        eq_or_diff(from_json(to_json($test->{data})), $expected, 'compare', {context => 10});
    },
    fixtures            => \@fixtures,
    fill_databases      => 0,
    application_package => 'Cron',
    init                => ['mail_notification', 'startrek', 'support']
);

sub filtered_block_bk_data {
    my ($model, $public_id) = @_;

    my @v = split_block_public_id($public_id);
    my $bkdata = get_bk_data($model, {public_id => $public_id});
    return +{$public_id => {DSPInfo => $bkdata->{$v[2]}{DSPInfo}}};
}

sub key_dsp {
    my ($v) = @_;
    return join(':', $v->{page_id}, $v->{block_id}, $v->{dsp_id});
}

sub get_dsp_data {
    my ($app) = @_;

    my $block_dsps             = $app->partner_db->block_dsps->get_all();
    my $block_dsps_unmoderated = $app->partner_db->block_dsps_unmoderated->get_all();

    my $diff_block_dsps;
    my $diff_block_dsps_unmoderated;
    if ($last_dsp_data) {
        my %h = map {key_dsp($_) => TRUE} @{$last_dsp_data->{block_dsps}};
        $diff_block_dsps = [grep {!$h{key_dsp($_)}} @$block_dsps];

        %h = map {key_dsp($_) => TRUE} @{$last_dsp_data->{block_dsps_unmoderated}};
        $diff_block_dsps_unmoderated = [grep {!$h{key_dsp($_)}} @$block_dsps_unmoderated];
    } else {
        $diff_block_dsps             = $block_dsps;
        $diff_block_dsps_unmoderated = $block_dsps_unmoderated;
    }

    $last_dsp_data = {
        block_dsps             => $block_dsps,
        block_dsps_unmoderated => $block_dsps_unmoderated,
    };

    return {
        block_dsps             => $diff_block_dsps,
        block_dsps_unmoderated => $diff_block_dsps_unmoderated,
    };
}
