#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use File::Path qw(make_path);
use Data::Rmap qw(rmap_hash);
use Test::Differences;
use Test::More;
use Test::Partner2::Mock;
use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use PiConstants qw($IS_PRECISE);

my @fields = qw(
  completed_percent
  error_data
  id
  log
  method_type
  method_name
  group_id
  multistate
  multistate_name
  params
  result
  user_id
  add_dt
  start_dt
  end_dt
  tries
  );

run_tests(
    sub {
        my ($app) = @_;

        my @got_data;
        mock_log(\@got_data);

        mock_curdate('2018-02-10 15:00:00');

        run_for_cron(
            $app,
            sub {

                $app->queue->add(
                    method_name => 'on_revoke_user_roles',
                    params      => {
                        roles_id => [9, 20, 27],
                        user => {id => 1009, client_id => 11009, login => 'mocked-yan-partner'}
                    },
                );

                push @got_data, {task_1_added => $app->queue->get_all(fields => \@fields)};

                $app->queue->add(
                    method_name => 'on_revoke_user_roles',
                    params      => {
                        roles_id => [9, 20, 27],
                        user => {id => 1009, client_id => 11009, login => 'mocked-yan-partner'}
                    },
                );

                push @got_data, {task_1_added_again => $app->queue->get_all(fields => \@fields)};

                mock_exception_in_task_code();

                my $task = $app->queue->grab_next_task();
                push @got_data, {task_1_id => $task->{id}};
                $app->queue->start($task);
                push @got_data, {task_1_failed => $app->queue->get_all(fields => \@fields)};

                mock_ok_task_code();

                $app->queue->restart_lost_tasks();
                push @got_data, {task_1_restart => $app->queue->get_all(fields => \@fields)};

                $task = $app->queue->grab_next_task();
                push @got_data, {has_task_1 => $task->{id}};
                $app->queue->start($task);
                push @got_data, {task_1_done => $app->queue->get_all(fields => \@fields)};
            }
        );

        my $expected = get_test_data_and_update_if_needed('data.json', \@got_data);
        if ($IS_PRECISE) {
            my $fix_data_sub = sub {
                my ($el) = @_;
                my @fields_to_num = qw(id multistate tries user_id task_1_id has_task_1);
                map {$el->{$_} += 0}
                  grep {defined $el->{$_}} @fields_to_num;
                if (defined $el->{result}) {
                    $el->{result} =~ s/"(\d+)"/$1/g;
                }
                $el;
            };
            rmap_hash {$fix_data_sub->($_)} @got_data;
            rmap_hash {$fix_data_sub->($_)} @$expected;
        }
        eq_or_diff(from_json(to_json(\@got_data)), $expected, 'compare', {context => 10});
    },
);

sub run_for_cron {
    my ($app, $sub) = @_;

    change_cur_user($app, 'system-cron');
    no warnings 'redefine';
    local *QBit::Application::check_rights = sub {TRUE};

    $sub->();
}

sub mock_exception_in_task_code {
    no warnings 'redefine';
    no strict 'refs';
    require LWP::UserAgent;
    *{'Application::Model::Users::_stop_and_delete_user_pages'} = sub {
        throw Exception 'mocked exception';
    };
}

sub mock_ok_task_code {
    no warnings 'redefine';
    no strict 'refs';
    require LWP::UserAgent;
    *{'Application::Model::Users::_stop_and_delete_user_pages'} = sub {
        return TRUE;
    };
}

sub mock_log {
    my ($data) = @_;
    no warnings 'redefine';
    no strict 'refs';
    require Application::Model::Queue;
    *{'Application::Model::Queue::ERROR'} = sub {
        push @$data, {ERROR => $_[0]->message};
    };
}
