#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::More;
use Test::Partner2::Mock;
use Test::Partner2::Simple;
use File::Path qw(make_path);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my @fields = qw(
  completed_percent
  error_data
  id
  log
  method_type
  method_name
  group_id
  multistate
  multistate_name
  params
  result
  user_id
  add_dt
  start_dt
  end_dt
  tries
  );

run_tests(
    sub {
        my ($app) = @_;

        my @got_data;

        mock_subs({'QBit::Application::check_rights' => sub {TRUE},});

        # Проверяем перезапуск тасок, залипших в статусе working
        mock_curdate('2018-02-10 15:00:00');
        $app->queue->add(
            method_name => 'send_email_to_processing',
            params      => {uid => 1},
            group_id    => 1,
        );
        push @got_data, {add_task_1 => $app->queue->get_all(fields => \@fields)};

        my $task = $app->queue->grab_next_task();
        push @got_data, {task_1_working => $app->queue->get_all(fields => \@fields)};

        $app->queue->restart_lost_tasks();
        push @got_data, {task_1_not_restart => $app->queue->get_all(fields => \@fields)};

        mock_curdate('2018-02-11 17:00:00');

        $app->queue->restart_lost_tasks();
        push @got_data, {task_1_restarted => $app->queue->get_all(fields => \@fields)};

        push @got_data, {next_task_1 => ($app->queue->grab_next_task() // {})->{id}};

        my $has = get_test_data_and_update_if_needed('data.json', \@got_data);

        eq_or_diff(from_json(to_json(\@got_data)), $has, 'compare data');

    },
    user => 'system-cron',
);
