use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner::Utils;
use Test::Differences;
use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my @logins = (
            {
                id     => 1009,                     #'mocked-yan-partner'
                rights => ['bk_statistics_view'],
            },
            {
                id => 1028,                         # 'mocked-indoor-partner'
            },
            {
                id => [
                    1009,                           # 'mocked-yan-partner'
                    1028,                           # 'mocked-indoor-partner'
                    1010,                           # 'mocked-video-partner'
                ]
            },
        );

        my @result;
        foreach my $login (@logins) {
            my $result = $app->rbac->get_rights_by_user_id($login->{id}, $login->{rights});
            push @result, [$login, $result];
        }
        my $has_data = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(from_json(to_json(\@result)), $has_data, 'checks');
    },
    user => 'yndx-developer',
);
