#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More tests => 3;
use Test::Differences;
use Test::Partner::Utils;

use qbit;

my $FILE_NAME = 'data.json';

run_tests(
    sub {
        my ($app) = @_;

        my $data = get_test_data_and_update_if_needed($FILE_NAME);    # Just read

        subtest 'test roles' => sub {
            plan tests => scalar @$data;

            foreach my $test (@$data) {
                my $result = from_json to_json $app->rbac->get_roles(%{$test->{args}});

                eq_or_diff($result, $test->{result}, $test->{name});

                $test->{result} = $result;                            # for autoupdate
            }
        };

        get_test_data_and_update_if_needed($FILE_NAME, $data);        # Just save if needed
    },
    do_not_die_on_fail => 1,
    init               => [qw(rbac)],
    locale             => 'C',
);
