#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $roles = $app->rbac->get_roles();
        my @accessor_roles = grep {exists($_->{'related_page_accessor'})} @$roles;

        foreach my $role (@accessor_roles) {
            ok(!$role->{is_internal}, "Role ID with related_page_accessor is external");
        }

        my @accessors = map {@{$_->{'related_page_accessor'}}} @accessor_roles;
        my @uniq_accessors = @{array_uniq @accessors};
        ok(scalar(@accessors) == scalar(@uniq_accessors), "Protected by owner roles accessors are uniq.");
    }
);
