#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_bk_data);

use DDP;
use Test::More;
use Test::Deep;
use Test::Exception;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        {
            no warnings 'redefine';
            no strict 'refs';

            *{'QBit::Application::Model::SendMail::send'} = sub { };
        }

        my $roles = $app->rbac->get_cur_user_roles();
        ok(keys(%$roles) == 0, 'Current user doesn\'t have role');

        {
            my $tmp_rights = $app->add_tmp_rights(qw(do_user_action_set_user_role rbac_user_role_set));
            $app->users->do_action(
                $app->get_option('cur_user')->{'id'}, 'set_user_role',
                role_id   => 15,
                allow_idm => TRUE
            );
        }

        $roles = $app->rbac->get_cur_user_roles();
        cmp_deeply(
            $roles,
            {
                '15' => {
                    'group'       => 3,
                    'name'        => 'YAN: Manager',
                    'id'          => 15,
                    'is_internal' => 1,
                    idm           => 'YAN_MANAGER',
                }
            },
            'Now I\'m manager!'
        );

        throws_ok {
            my $tmp_rights = $app->add_tmp_rights(qw(do_user_action_set_user_role rbac_user_role_set));
            $app->users->do_action($app->get_option('cur_user')->{'id'}, 'set_user_role', role_id => 9);
        }
        qr/Role "YAN Sites: Partner" incompatible with roles: YAN: Manager/,
          'Can\'t set both internal and external roles for one user';
    },
    user => 'some-other-login',
    init => [qw(mailer)],
);
