#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed get_test_data_path);
use Test::Differences;

run_tests(\&main_test,);

sub main_test {
    my ($app) = @_;

    mock_curdate('2018-10-10 15:00:00');
    mock_balance($app);
    mock_blackbox($app);

    mock_subs(
        {
            'Application::Model::AgreementChecker::_Agreement::_is_live' => sub {
                TRUE
            },
            'Partner2::query_fias' => sub {
                ''
            },
        }
    );

    foreach my $filepath (sort glob(get_test_data_path() . '/*.json')) {
        my ($filename, $name) = ($filepath =~ m|/(([^/]+)\.json)|);
        my $data = from_json(readfile($filepath));
        mock_balance_contract($app, $data->{balance});
        $data->{result} = make_test($app, $data->{balance}{Person}{type});
        my $has = get_test_data_and_update_if_needed($filename, $data);
        eq_or_diff($data, $has, $name);
    }

}

sub make_test {
    my ($app, $cooperation_form) = @_;

    $app->users->do_action(1009, 'edit', 'cooperation_form', $cooperation_form);
    $app->set_cur_user({id => 1009, login => 'mocked-yan-partner'});
    my $data = $app->requisites->fields();

    return $data;
}

sub mock_balance_contract {
    my ($app, $balance_data) = @_;

    my $data = clone $balance_data;

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

    $app->{'api_balance'}->mock(
        'call',
        sub {
            my ($self, $method, $operator_uid, $opts) = @_;

            if ($method eq 'Balance.GetPartnerContracts') {
                return [[$data]];
            }
        }
    );
}
