#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Partner::Utils;
use Test::Differences;

use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my %data;

        mock_curdate('2018-12-01 15:00:00');
        change_cur_user($app, 'mocked-yan-partner');
        $data{'2018-12-01'} = $app->resources->get_available_resources([qw(common_offer context_on_site_campaign)]);

        $app->partner_db->common_offer_allowed_users->add_multi(
            [
                {
                    user_id  => 1009,
                    deadline => '2018-12-02',
                },
            ]
        );

        mock_curdate('2018-12-02 15:00:00');
        change_cur_user($app, 'mocked-yan-partner');
        $data{'2018-12-02'} = $app->resources->get_available_resources([qw(common_offer context_on_site_campaign)]);

        mock_curdate('2018-12-03 15:00:00');
        change_cur_user($app, 'mocked-yan-partner');
        $data{'2018-12-03'} = $app->resources->get_available_resources([qw(common_offer context_on_site_campaign)]);

        change_cur_user($app, 'mocked-yan-partner-assistant');
        $data{'ass_before'} = $app->context_on_site_campaign->get_all(fields => ['page_id']);

        $app->partner_db->assistants->edit($app->partner_db->assistants->filter({user_id => 1018}), {dissabled => 1});

        $data{'ass_after'} = $app->context_on_site_campaign->get_all(fields => ['page_id']);

        my $has = get_test_data_and_update_if_needed('data.json', \%data);
        eq_or_diff(from_json(to_json(\%data)), $has, 'compare data');

    },
    do_not_die_on_fail => TRUE,
    #user => 'mocked-yan-partner',
    create_clickhouse_db => TRUE,
);
