#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        change_cur_user($app, 'mocked-yan-partner');

        my %avaliable_resources =
          map {$_->{'resource'} => $_->{'methods'}} @{$app->resources->get_available_resources()};

        ok(!exists($avaliable_resources{'users'}), 'available resources does not contain users');

        my $api_resources = $app->resources->get_api_resources();

        ok(exists($api_resources->{'users'}), 'api resources contain users');
    },
    create_clickhouse_db => TRUE,
);
