#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Clone;
use Test::More;
use Test::Differences;

use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Mock qw(mock_subs);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2019-01-15 12:00:00');

        my $path_to_data = lib::abs::path('get_available_resources/data.json');
        my $json_data    = from_json(readfile($path_to_data));

        mock_subs({'Application::Model::Statistics::Product::is_available' => sub {TRUE},});

        my %data;
        for my $login (@{$json_data->{logins}}) {
            $app->{'__CURRENT_USER_RIGHTS__'} = {};
            $app->set_cur_user(clone $login);
            my $out = $app->resources->get_available_resources();

            $out = [sort {$a->{resource} cmp $b->{resource}} @{$out}];
            $data{$login->{login}} = $out;
        }

        eq_or_diff(
            to_json(\%data,               pretty => TRUE),
            to_json($json_data->{result}, pretty => TRUE),
            'available_resources'
        );

        # Usage: > ./prove *.t :: --self_update 2>&1 | less
        if (need_self_update()) {
            $json_data->{result} = \%data;
            foreach my $login (@{$json_data->{logins}}) {delete $login->{rights}}
            writefile($path_to_data, to_json($json_data, pretty => TRUE));
        }
    },
    do_not_die_on_fail => TRUE,
    init               => ['statistics_dsp']
);
