#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::More tests => 3;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Partner2::Simple;

use qbit;

my $OTHER_ID   = '123456';
my $REQUEST_ID = '654321';

my $empty_object;

run_tests(
    sub {
        my ($app) = @_;

        my %data;
        $data{'without page, without site version'} = $app->context_on_site_rtb->get_available_design_template_types();
        foreach my $site_version (qw(desktop mobile turbo turbo_desktop amp)) {
            $data{'without page, ' . $site_version} =
              $app->context_on_site_rtb->get_available_design_template_types({site_version => $site_version,});
            $data{'page without features, ' . $site_version} =
              $app->context_on_site_rtb->get_available_design_template_types(
                {
                    page_id      => 802,
                    site_version => $site_version,
                }
              );
            $data{'page with features, ' . $site_version} =
              $app->context_on_site_rtb->get_available_design_template_types(
                {
                    page_id      => 1,
                    show_video   => 1,
                    site_version => $site_version,
                }
              );
        }
        my $expected_data = get_test_data_and_update_if_needed('data.json', \%data);
        eq_or_diff(\%data, $expected_data, 'check');
    },
    locale => 'C',
);
