#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Deep;

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

use PiConstants qw($DO_ACTION_USE_QUEUE_KEY);

my $PUBLIC_ID = 'R-A-41443-1';
my $OBJ = {campaign_id => 41443, id => 1};

my $EXPECTED_QUEUE_PARAMS;
my $EXPECTED_DO_ACTION_PARAMS;

my $USE_QUEUE = TRUE;

my $ERROR;

run_tests(
    sub {
        my ($app) = @_;

        mock_subs(
            {
                'Application::Model::Queue::add' => sub {
                    my ($self, %params) = @_;

                    ok($USE_QUEUE, 'Use queue');

                    cmp_deeply(\%params, $EXPECTED_QUEUE_PARAMS, 'check params for queue');
                },
                'Application::Model::Product::do_action' => sub {
                    my ($self, @params) = @_;

                    ok(!$USE_QUEUE, 'Use do_action');

                    cmp_deeply(\@params, $EXPECTED_DO_ACTION_PARAMS, 'check params for do_action');
                },
                'Application::Model::Role::JavaJsonApiProxy::ERROR' => sub {
                    my (@args) = @_;

                    $ERROR = $args[0];
                },
            }
        );

        #default use queue
        check_queue($app);

        check_action_and_use_do_action($app);

        #use do_action
        $app->kv_store->set($DO_ACTION_USE_QUEUE_KEY, '{"context_on_site_rtb":false}');
        check_do_action($app);
    },
    init => [qw(context_on_site_rtb queue)],
);

sub check_queue {
    my ($app) = @_;

    $EXPECTED_QUEUE_PARAMS = {
        'group_id'    => '41443',
        'method_name' => 'do_action',
        'params'      => {
            'actionName' => 'stop',
            'modelIds'   => [$PUBLIC_ID],
            'modelName'  => 'context_on_site_rtb',
            'userId'     => 155209804
        }
    };
    $app->context_on_site_rtb->do_action($PUBLIC_ID, 'stop');

    $app->context_on_site_rtb->do_action($OBJ, 'stop');
}

sub check_action_and_use_do_action {
    my ($app) = @_;

    $USE_QUEUE = FALSE;

    $EXPECTED_DO_ACTION_PARAMS = [$PUBLIC_ID, 'edit', caption => 'Test caption'];
    $app->context_on_site_rtb->do_action(@$EXPECTED_DO_ACTION_PARAMS);

    ok($ERROR->{'message'} =~ /called for action 'edit'/, 'Correct errror message');
}

sub check_do_action {
    my ($app) = @_;

    $USE_QUEUE = FALSE;

    $EXPECTED_DO_ACTION_PARAMS = [$PUBLIC_ID, 'stop'];
    $app->context_on_site_rtb->do_action(@$EXPECTED_DO_ACTION_PARAMS);

    $EXPECTED_DO_ACTION_PARAMS = [$OBJ, 'stop'];
    $app->context_on_site_rtb->do_action(@$EXPECTED_DO_ACTION_PARAMS);
}
