#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Deep;

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

use PiConstants qw($DO_ACTION_USE_QUEUE_KEY);

my $PUBLIC_ID = 'R-A-41443-1';

my $EXPECTED_DO_ACTION_PARAMS;

my $ERROR;

my @DO_ACTIONS = qw(do_action_with_result force_do_action maybe_do_action);

run_tests(
    sub {
        my ($app) = @_;

        mock_subs(
            {
                'Application::Model::Role::JavaJsonApiProxy::ERROR' => sub {
                    my (@args) = @_;

                    $ERROR = $args[0];
                },
                map {
                    my $method = $_;
                    +"Application::Model::Product::$method" => sub {
                        my ($self, @params) = @_;

                        cmp_deeply(\@params, $EXPECTED_DO_ACTION_PARAMS, "check params for $method");
                      }
                  } @DO_ACTIONS
            }
        );

        #use do_action
        $app->kv_store->set($DO_ACTION_USE_QUEUE_KEY, '{"context_on_site_rtb":false}');
        check_do_actions($app);
    },
    init => [qw(context_on_site_rtb)],
);

sub check_do_actions {
    my ($app) = @_;

    $EXPECTED_DO_ACTION_PARAMS = [$PUBLIC_ID, 'stop'];

    foreach my $do_action (@DO_ACTIONS) {
        $app->context_on_site_rtb->$do_action(@$EXPECTED_DO_ACTION_PARAMS);
        ok($ERROR->{'message'} =~ /$do_action/, 'Correct errror message');
    }
}
