#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Fixture;
use Test::Differences;
use qbit;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my $cases = [
            {
                name  => 'isnt availible after create',
                value => FALSE,
            },
            {
                name    => 'is not availible after set_need_update',
                value   => FALSE,
                actions => ['set_need_update'],
            },
            {
                name    => 'is availible after reject',
                value   => TRUE,
                actions => ['reject'],
            },
            {
                name    => 'is not availible after approve',
                value   => FALSE,
                actions => ['set_need_approve', 'approve'],
            }
        ];

        my $page       = get_fixture('partner_context_page');
        my $page_model = 'context_on_site_campaign';

        my $obj = $app->$page_model->get_all(
            fields => [qw(id is_remoderation_available)],
            filter => {multistate => '__EMPTY__'}
        )->[0];

        for my $case (@$cases) {
            $app->$page_model->do_action($obj->{id}, $_) for (@{$case->{actions}});
            $obj = $app->$page_model->get($obj, fields => [qw(id is_remoderation_available)]);
            is($obj->{is_remoderation_available}, $case->{value}, $case->{name});
        }
    },
    fill_databases => 0,
    fixtures       => [qw(partner_context_page)],
);
