package TestApp::Model::BaseTestModel;

use qbit;

use base qw(Application::Model::Product);

sub accessor {'base_test_model'}

sub get_product_name {'base_test_model'}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->register_rights($self->get_structure_rights_to_register());
    $self->model_fields($self->get_structure_model_fields());
    $self->model_filter($self->get_structure_model_filter());
    $self->multistates_graph($self->get_structure_multistates_graph());
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {field_from_base_model => {type => 'number'},};
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        db_accessor => 'partner_db',
        fields      => {field_from_base_model => {type => 'publicid',},},
    };
}

sub get_structure_rights_to_register {
    my ($self) = @_;
    return [
        {
            name        => $self->accessor(),
            description => d_gettext('Right to manage ' . $self->accessor()),
            rights      => {
                (
                    map {$self->get_description_right($_)}
                      qw(
                      view_field__field_from_base_model
                      edit_field__field_from_base_model
                      ),
                ),
            }
        }
    ];
}

sub get_structure_multistates_graph {{}}

1;
