package TestApp::Model::Role::Has::FieldThatAffectsBkData;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    return {field_that_affects_bk_data => {type => 'boolean'},};
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__field_that_affects_bk_data
                  edit_field__field_that_affects_bk_data
                  ),
            }
        }
    ];
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__field_that_affects_bk_data')) {
        $fields->{field_that_affects_bk_data} = 1;
    } else {
        delete $fields->{field_that_affects_bk_data};
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__field_that_affects_bk_data')) {
        $fields->{field_that_affects_bk_data} = 1;
    } else {
        delete $fields->{field_that_affects_bk_data};
    }

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {field_that_affects_bk_data => 1,};
}

sub get_bk_data {
    my ($self, $page, $data) = @_;

    $data->{'field-that-affects-bk-data'} = $page->{field_that_affects_bk_data};

    return %$data;
}

1;
