package TestApp::Model::TestModel;

use qbit;

use base qw(TestApp::Model::BaseTestModel);

consume 'TestApp::Model::Role::Has::TwoFields',
  'TestApp::Model::Role::Has::FieldThatAffectsBkData',
  'TestApp::Model::Role::Has::FieldThatAffectsActions',
  'TestApp::Model::Role::Has::FieldsFromRelatedModel';

sub accessor {'test_model'}

sub get_product_name {'test_model'}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->register_rights($self->get_structure_rights_to_register());
    $self->model_fields($self->get_structure_model_fields());
    $self->model_filter($self->get_structure_model_filter());
    $self->multistates_graph($self->get_structure_multistates_graph());
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {%{$self->SUPER::get_structure_model_fields()}, field_from_model => {type => 'number'},};
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        db_accessor => 'partner_db',
        fields => {%{$self->SUPER::get_structure_model_filter()->{fields}}, field_from_model => {type => 'publicid',},},
    };
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [{name => 'field_from_model'},];
}

sub get_structure_rights_to_register {
    my ($self) = @_;
    return [
        {
            name        => $self->accessor(),
            description => d_gettext('Right to manage ' . $self->accessor()),
            rights      => {
                %{$self->SUPER::get_structure_rights_to_register()->[0]{rights}},
                (
                    map {$self->get_description_right($_)}
                      qw(
                      view_field__field_from_model
                      edit_field__field_from_model
                      ),
                ),
            }
        }
    ];
}

sub get_structure_model_accessors {
    {'accessed_model' => 'TestApp::Model::AccessedModel',};
}

sub get_need_update_in_bk_fields {{field_from_model => 1}}

sub get_structure_multistates_graph {{}}

sub get_bk_data {
    my ($self, $data) = @_;
    return ('field-from-model' => $data->{field_from_model},);
}

sub get_actions_depends {[qw(field_from_model)]}

sub get_available_fields {{field_from_model => 1}}

sub collect_editable_fields {{field_from_model => 1}}

sub related_models {{other_model => {accessor => 'accessed_model'}}}

1;
