#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 20;

use qbit;

use Test::Partner2::Simple;

{
    no strict 'refs';
    no warnings 'redefine';
    *{'QBit::Application::check_rights'} = sub {TRUE};
}

run_tests(
    sub {
        my ($app) = @_;

        $app->set_cur_user({id => 0});

        for my $model (@{$app->product_manager->get_page_model_accessors}) {
            next unless exists $app->$model->get_model_fields->{tier};
            my $pk   = $app->$model->get_pk_fields;
            my $list = $app->$model->get_all(
                fields => [@$pk, "tier"],
                limit  => 1,
            );

            my $row = $list->[0];

            is($row->{tier}, 3, "$model default tier");

            $app->$model->do_action($list->[0], 'edit', tier => 1);

            delete $row->{tier};

            $row = $app->$model->get($row, fields => ["tier"],);

            is($row->{tier}, 1, "$model set tier");
        }
    },
    do_not_die_on_fail => 1,
);
