#!/usr/bin/perl

use qbit;

use lib::abs qw(.);

use Test::More tests => 10;

use TestApp;

my $tapp = TestApp->new();
$tapp->pre_run();

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

is_deeply(
    [sort keys %{$tapp->test_model->get_structure_model_accessors()}],
    [
        qw(
          accessed_model
          related_model
          )
    ],
    'get_structure_model_accessors'
);
is_deeply(
    [sort keys %{$tapp->test_model->get_structure_model_fields()}],
    [
        qw(
          actions
          field_from_base_model
          field_from_model
          field_from_role
          field_that_affects_actions
          field_that_affects_bk_data
          field_that_depends_on_related_model
          second_field_from_role
          )
    ],
    'get_structure_model_fields'
);
is_deeply(
    [sort keys %{$tapp->test_model->get_structure_model_filter()->{fields}}],
    [
        qw(
          field_from_base_model
          field_from_model
          field_from_role
          )
    ],
    'get_structure_model_fields'
);
is_deeply(
    [sort map {$_->{name}} @{$tapp->test_model->get_db_filter_simple_fields()}],
    [
        qw(
          field_from_model
          field_from_role
          )
    ],
    'get_db_filter_simple_fields'
);
is_deeply(
    [sort keys %{$tapp->test_model->get_structure_rights_to_register()->[0]{rights}}],
    [
        qw(
          test_model_edit_field__field_from_base_model
          test_model_edit_field__field_from_model
          test_model_edit_field__field_that_affects_bk_data
          test_model_view_field__field_from_base_model
          test_model_view_field__field_from_model
          test_model_view_field__field_that_affects_bk_data
          )
    ],
    'get_structure_rights_to_register'
);
is_deeply(
    [sort keys %{$tapp->test_model->get_available_fields()}],
    [
        qw(
          field_from_model
          field_from_role
          field_that_affects_bk_data
          )
    ],
    'get_available_fields'
);
is_deeply(
    [sort keys %{$tapp->test_model->collect_editable_fields()}],
    [
        qw(
          field_from_model
          field_from_role
          field_that_affects_bk_data
          )
    ],
    'collect_editable_fields'
);
is_deeply(
    [sort @{$tapp->test_model->get_actions_depends()}],
    [
        qw(
          field_from_model
          field_that_affects_actions
          )
    ],
    'get_actions_depends'
);
is_deeply(
    [sort keys %{$tapp->test_model->related_models()}],
    [
        qw(
          other_model
          related_model
          )
    ],
    'related_models'
);
is_deeply(
    {$tapp->test_model->get_bk_data({field_that_affects_bk_data => 1})},
    {
        'field-from-model'           => undef,
        'field-that-affects-bk-data' => 1,
    },
    'get_bk_data'
);
