#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_bk mock_utils_partner2);

use Test::Differences qw(eq_or_diff);
use Test::MockObject::Extends;
use Test::More;
use Test::Partner::Utils
  qw(ssp_mock_httpmaas ssp_mock_lwp_for_yql mock_curdate get_bk_data convert_design_to_object get_test_data_and_update_if_needed);

my $DT_STRING = '2016-05-25';
my $DT_EPOCH = trdate("db", "sec", $DT_STRING);

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_utils_partner2($app);

        mock_curdate('2016-05-25 18:12:18');

        {    # create raw impressions
            ssp_mock_httpmaas($app);
            ssp_mock_lwp_for_yql($DT_EPOCH, 'video');

            $app->api_balance;
            $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});
            $app->api_balance->mock('create_or_update_place', sub {1});

            no warnings 'once';
            $Application::Model::Product::SSP::ImpressionLog::MIN_ROWS             = 1;
            $Application::Model::Product::SSP::ImpressionLog::QUERY_EXECUTION_TIME = undef;

            $app->ssp_imps->update_data($DT_STRING);
        }

        {    # create apps
            my $video_apps = $app->ssp_application->get_all(fields => ['id', 'bundle_id', 'apple_id', 'store_id']);
            is(@$video_apps, 5, 'Import. Fold apps');
        }

        {    # check limits
            no warnings 'once';
            local $Application::Model::Product::SSP::ImpressionLog::MAX_LEN_SELLER_TOKENS = 1;

            {
                no warnings 'redefine';
                local *Application::Model::Product::SSP::ImpressionLog::WARNF = sub {
                    is($_[0], "SSP error. Too much (%d) tokens (\"%s\", ...) for one SSP (%d)");
                    is($_[1], 2);
                    # like this bc there is uncertainty in MySQL sorting
                    like($_[2], '/^com.alterego.skazka.littlekids_t[1|2]$/');
                    is($_[3], 7952356);
                };
                $app->ssp_link_video_app->update_data($DT_STRING);
            }

            is(@{$app->ssp_link_video_app->get_all()}, 3, 'Import. Check limit.');
        }

        {    # create moderations
            $app->ssp_link_video_app->update_data($DT_STRING);
            my $links = $app->ssp_link_video_app->get_all(fields => ['id', 'seller', 'application']);
            is(@$links, 4, 'Import. create links');
        }

        {    # api
            my $links = $app->ssp_link_video_app->get_all(
                fields => ['id', 'seller', 'application', 'weight', 'state_name', 'video_app', 'actions']);
            my $expected = get_test_data_and_update_if_needed('api_data.json', $links);
            eq_or_diff($links, $expected, 'Freeze API data (links)', {context => 5});
        }

        # like this bc there is uncertainty in MySQL sorting
        my $key_tokens_sorted = [sort ('com.alterego.skazka.littlekids_t1', 'com.alterego.skazka.littlekids_t2')];
        {    # create app
            my $state;
            my $link = $app->ssp_link_video_app->get_all(
                fields => ['id', 'seller', 'application', 'weight', 'state_name', 'video_app', 'actions'],
                filter => [AND => [[application => MATCH => [id => '=' => 5]], [seller_id => '=' => 7952356]]]
            )->[0];
            my $expected = get_test_data_and_update_if_needed('find_link.json', $link);
            eq_or_diff($link, $expected, 'Find link (by application_id)', {context => 5});

            $state = $app->ssp_link_video_app->do_action($link, 'reject');
            is($state, 4, 'Reject link');

            $state = $app->ssp_link_video_app->do_action($link, 'approve_first');
            is($state, 2, 'Approve link');

            my $video_app = $app->ssp_video_an_site->get(1000, fields => [qw(multistate)]);
            ok($app->ssp_video_an_site->check_multistate_flag($video_app->{'multistate'}, 'working'),
                'new page is working');

            $state = $app->ssp_link_video_app->do_action($link, 'edit', moderation_reason_id => 2);
            is($state, 2, 'Reject link (via edit)');

            $link =
              $app->ssp_link_video_app->get($link->{id},
                fields => ['id', 'tokens', 'seller', 'application', 'weight', 'state_name', 'video_app', 'actions'],);
            cmp_ok($link->{video_app}->{page_id}, '>', 1, 'Page ID - created');

            # like this bc there is uncertainty in MySQL sorting
            $link->{tokens} = [sort @{$link->{tokens}}];

            $expected = get_test_data_and_update_if_needed('all_link_data.json', $link);
            eq_or_diff($link, $expected, 'Freeze all link data', {context => 5});

        }

        {    # bk
            my $m_app = $app->ssp_video_an_site->get({id => 1000},
                fields => [qw(id page_id multistate owner_id seller_id client_id tokens bundle_id store_id)]);

            # like this bc there is uncertainty in MySQL sorting
            $m_app->{tokens} = [sort @{$m_app->{tokens}}];
            my $expected = get_test_data_and_update_if_needed('mobile_app_denormalized.json', $m_app);
            eq_or_diff($m_app, $expected, 'Mobile App denormalized', {context => 5});

            my $bk_data = get_bk_data($app->ssp_video_an_site, {id => $m_app->{'id'}});

            # like this bc there is uncertainty in MySQL sorting
            $bk_data->{ssp_source_tokens} = [sort @{$bk_data->{ssp_source_tokens}}];

            $expected = get_test_data_and_update_if_needed("bk_data.json", $bk_data);
            is_deeply($bk_data, $expected, 'Freze BK data');

        }

        {    # logs
            my $logs = $app->ssp_link_video_app->get_moderation_history(4);
            my $expected = get_test_data_and_update_if_needed('moderation_history.json', $logs);
            eq_or_diff($logs, $expected, 'Moderation history (for link 4)', {context => 5});
        }

        {    # other linkgs

            my $links = $app->ssp_link_video_app->get_other_links(4);
            my $expected = get_test_data_and_update_if_needed('other_links.json', $links);
            eq_or_diff($links, $expected, 'Freeze other links (for link 4)', {context => 5});
        }

        {    # dict
            my $dict;
            $dict = $app->ssp_link_video_app->dict_reasons();
            my $expected = get_test_data_and_update_if_needed('reasons_dict.json', $dict);
            eq_or_diff($dict, $expected, 'Freze Reasons dict (all)', {context => 5});

            $dict = $app->ssp_link_video_app->dict_reasons(by_id => TRUE);
            eq_or_diff(
                $dict->{2},
                {
                    'title' => 'partner. direct',
                    'id'    => '2'
                },
                'Freeze reasons by_id (dict)',
                {context => 5}
            );
        }

        {    # hits
            my $hits = $app->ssp_link_video_app->get_hits_all(4);
            my $expected = get_test_data_and_update_if_needed('hits.json', $hits);
            eq_or_diff($hits, $expected, 'Freeze hits (for link 4)', {context => 5});
        }

        {    #check pages status
            my $link_id = 4;
            my $id      = 1000;

            my $video_app = $app->ssp_video_an_site->get($id, fields => [qw(multistate)]);
            ok($app->ssp_video_an_site->check_multistate_flag($video_app->{'multistate'}, 'stopped'),
                'page on rejected link is stopped');

            $app->ssp_link_video_app->do_action($link_id, 'edit', moderation_reason_id => 0);
            $video_app = $app->ssp_video_an_site->get($id, fields => [qw(multistate)]);
            is($app->ssp_video_an_site->check_multistate_flag($video_app->{'multistate'}, 'working'),
                1, 'page on approved link is working');
        }
    },
    init               => [qw(ssp_imps)],
    do_not_die_on_fail => 1
);
