#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_bk mock_utils_partner2 mock_curdate);
use Test::Partner::Utils qw(get_bk_data convert_design_to_object get_test_data_and_update_if_needed);

use Test::Differences qw(eq_or_diff);
use Test::MockObject::Extends;
use Test::More;
use Test::Partner::Utils
  qw(mock_curdate get_bk_data ssp_mock_lwp_for_yql ssp_mock_httpmaas get_test_data_and_update_if_needed);

my $DT_STRING = '2016-05-25';
my $DT_EPOCH = trdate("db", "sec", $DT_STRING);

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_utils_partner2($app);

        mock_curdate('2016-05-25 18:12:18');

        {    # create raw impressions

            $app->api_balance;
            $app->{'api_balance'} =
              Test::MockObject::Extends->new($app->api_balance)->mock('create_or_update_place', sub {TRUE});

            ssp_mock_lwp_for_yql($DT_EPOCH, 'web');

            no warnings 'once';
            $Application::Model::Product::SSP::ImpressionLog::MIN_ROWS             = 1;
            $Application::Model::Product::SSP::ImpressionLog::QUERY_EXECUTION_TIME = undef;

            $app->ssp_imps->update_data($DT_STRING);
        }

        {    # create sites
            my $sites = $app->ssp_site->get_all(fields => ['id', 'domain']);
            is(@$sites, 3, 'Import. Fold sites');
        }

        {    # create moderations
            $app->ssp_link_context_rtb->update_data($DT_STRING);
            my $links = $app->ssp_link_context_rtb->get_all(fields => ['id', 'seller', 'site']);
            is(@$links, 3, 'Import. create links');
        }

        {    # api
            my $links = $app->ssp_link_context_rtb->get_all(
                fields => ['id', 'seller', 'site', 'weight', 'state_name', 'context_rtb', 'actions']);
            my $expected = get_test_data_and_update_if_needed('api_data.json', $links);
            eq_or_diff($links, $expected, 'Freeze API data (links)', {context => 5});
        }

        {    # create web
            $app->{'api_balance'} = Test::MockObject::Extends->new($app->api_balance);
            $app->api_balance->mock('create_or_update_place', sub {1});

            my $state;
            my $link = $app->ssp_link_context_rtb->get_all(
                fields => ['id', 'seller', 'site', 'weight', 'state_name', 'context_rtb', 'actions'],
                filter => [AND => [[site => MATCH => [id => '=' => 3]], [seller_id => '=' => 7952356]]]
            )->[0];
            my $expected = get_test_data_and_update_if_needed('find_link.json', $link);
            eq_or_diff($link, $expected, 'Find link (by application_id)', {context => 5});

            $state = $app->ssp_link_context_rtb->do_action($link, 'reject');
            is($state, 4, 'Reject link');

            # $state = $app->ssp_link_context_rtb->do_action($link, 'approve_first');
            $state = $app->ssp_link_context_rtb->do_action($link, 'edit', moderation_reason_id => 0);
            is($state, 4, 'Approve link (via edit)');

            my $campaign = $app->ssp_context_on_site_campaign->get(1000, fields => [qw(multistate)]);
            ok($app->ssp_context_on_site_campaign->check_multistate_flag($campaign->{'multistate'}, 'working'),
                'new page is working');

            $link =
              $app->ssp_link_context_rtb->get($link->{id},
                fields => ['id', 'seller', 'site', 'weight', 'state_name', 'context_rtb', 'actions']);
            is($link->{context_rtb}->{id}, 1000, 'RTB createdk');

            $state = $app->ssp_link_context_rtb->do_action($link, 'edit', moderation_reason_id => 2);
            is($state, 2, 'Reject link (via edit)');

            # get page_id
            $app->ssp_context_on_site_campaign->update_in_bk($link->{context_rtb});

            $link =
              $app->ssp_link_context_rtb->get($link->{id},
                fields => ['id', 'tokens', 'seller', 'site', 'weight', 'state_name', 'context_rtb', 'actions'],);
            cmp_ok($link->{context_rtb}->{page_id}, '>', 1, 'Page ID - created');

            $expected = get_test_data_and_update_if_needed('all_link_data.json', $link);
            eq_or_diff($link, $expected, 'Freeze all link data', {context => 5});
        }

        {    # bk
            my $m_app = $app->ssp_context_on_site_campaign->get({id => 1000}, fields => [qw(id page_id multistate)]);
            my $bk_data = get_bk_data($app->ssp_context_on_site_campaign, {id => $m_app->{'id'}});

            my $expected = get_test_data_and_update_if_needed("bk_data.json", $bk_data);
            is_deeply($bk_data, $expected, 'Freze BK data');
        }

        my $link_id = 3;
        {    # logs
            my $logs = $app->ssp_link_context_rtb->get_moderation_history($link_id);
            my $expected = get_test_data_and_update_if_needed('moderation_history.json', $logs);
            eq_or_diff($logs, $expected, 'Moderation history (for link 1)', {context => 5});
        }

        {    # other linkgs

            my $links = $app->ssp_link_context_rtb->get_other_links($link_id);
            my $expected = get_test_data_and_update_if_needed('other_links.json', $links);
            eq_or_diff($links, $expected, 'Freeze other links (for link 2)', {context => 5});
        }

        {    # dict
            my $dict;
            $dict = $app->ssp_link_context_rtb->dict_reasons();
            my $expected = get_test_data_and_update_if_needed('reasons_dict.json', $dict);
            eq_or_diff($dict, $expected, 'Freze Reasons dict (all)', {context => 5});
        }

        {    # hits
            my $hits = $app->ssp_link_context_rtb->get_hits_all($link_id);
            my $expected = get_test_data_and_update_if_needed('hits.json', $hits);
            eq_or_diff($hits, $expected, 'Freeze hits (for link 3)', {context => 5});
        }

        {    #check pages status
            my $id = 1000;

            my $campaign = $app->ssp_context_on_site_campaign->get($id, fields => [qw(multistate)]);
            ok($app->ssp_context_on_site_campaign->check_multistate_flag($campaign->{'multistate'}, 'stopped'),
                'page on rejected link is stopped');

            $app->ssp_link_context_rtb->do_action($link_id, 'edit', moderation_reason_id => 0);
            $campaign = $app->ssp_context_on_site_campaign->get($id, fields => [qw(multistate)]);
            is($app->ssp_context_on_site_campaign->check_multistate_flag($campaign->{'multistate'}, 'working'),
                1, 'page on approved link is working');
        }
    },
    init               => [qw(ssp_imps)],
    do_not_die_on_fail => 1
);
