#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_bk mock_utils_partner2 mock_curdate);

use Test::Differences qw(eq_or_diff);
use Test::MockObject::Extends;
use Test::More;
use Test::Partner::Utils qw(mock_curdate  ssp_mock_lwp_for_yql  );
use Test::Exception;

my $DT_STRING = '2016-05-25';
my $DT_EPOCH = trdate("db", "sec", $DT_STRING);

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_utils_partner2($app);

        mock_curdate('2016-05-25 18:12:18');
        {
            no warnings 'once';
            $Application::Model::Product::SSP::ImpressionLog::MIN_ROWS             = 1;
            $Application::Model::Product::SSP::ImpressionLog::QUERY_EXECUTION_TIME = undef;

        }

        $app->api_balance;
        $app->{'api_balance'} =
          Test::MockObject::Extends->new($app->api_balance)->mock('create_or_update_place', sub {TRUE});
        ssp_mock_lwp_for_yql($DT_EPOCH, 'web');
        $app->ssp_imps->update_data($DT_STRING);
        # create sites
        my $sites = $app->ssp_site->get_all(fields => ['id', 'domain']);
        # create moderations
        $app->ssp_link_context_rtb->update_data($DT_STRING);
        my $links = $app->ssp_link_context_rtb->get_all(fields => ['id', 'seller', 'site']);

        # api
        #     my $links = $app->ssp_link_context_rtb->get_all(
        #         fields => ['id', 'seller', 'site', 'weight', 'state_name', 'context_rtb', 'actions']);

        my $state;
        my $link = $app->ssp_link_context_rtb->get_all(
            fields => ['id', 'seller', 'site', 'weight', 'state_name', 'context_rtb', 'actions'],
            filter => [AND => [[site => MATCH => [id => '=' => 3]], [seller_id => '=' => 7952356]]]
        )->[0];

        $state = $app->ssp_link_context_rtb->do_action($link, 'reject');
        $state = $app->ssp_link_context_rtb->do_action($link, 'edit', moderation_reason_id => 0);

        my $campaign = $app->ssp_context_on_site_campaign->get(1000, fields => [qw(multistate)]);
        ok($app->ssp_context_on_site_campaign->check_multistate_flag($campaign->{'multistate'}, 'working'),
            'new page is working');

        $link =
          $app->ssp_link_context_rtb->get($link->{id},
            fields => ['id', 'seller', 'site', 'weight', 'state_name', 'context_rtb', 'actions']);
        is($link->{context_rtb}->{id}, 1000, 'RTB createdk');

        $state = $app->ssp_link_context_rtb->do_action($link, 'edit', moderation_reason_id => 2);
        is($state, 2, 'Reject link (via edit)');

        # get page_id
        $app->ssp_context_on_site_campaign->update_in_bk($link->{context_rtb});

        $link =
          $app->ssp_link_context_rtb->get($link->{id},
            fields => ['id', 'tokens', 'seller', 'site', 'weight', 'state_name', 'context_rtb', 'actions'],);
        cmp_ok($link->{context_rtb}->{page_id}, '>', 1, 'Page ID - created');

        #check pages status
        my $link_id = 3;
        my $id      = 1000;

        $campaign = $app->ssp_context_on_site_campaign->get($id, fields => [qw(multistate)]);
        ok($app->ssp_context_on_site_campaign->check_multistate_flag($campaign->{'multistate'}, 'stopped'),
            'page on rejected link is stopped');

        $app->ssp_link_context_rtb->do_action($link_id, 'edit', moderation_reason_id => 0);
        $campaign = $app->ssp_context_on_site_campaign->get($id, fields => [qw(multistate multistate_name)]);
        is($app->ssp_context_on_site_campaign->check_multistate_flag($campaign->{'multistate'}, 'working'),
            1, 'page on approved link is working');

        my $tmp_right = $app->add_tmp_rights(
            'do_ssp_context_on_site_campaign_edit',
            'ssp_context_on_site_campaign_edit',
            'ssp_context_on_site_campaign_edit_field__patch',
        );

        $app->{'ssp_context_on_site_campaign'} =
          Test::MockObject::Extends->new($app->ssp_context_on_site_campaign)->mock(
            'get_editable_fields',
            sub {
                +{patch => TRUE,};
            }
          );

        throws_ok {
            $app->ssp_context_on_site_campaign->do_action($id, "edit", patch => {SSPID => undef,});
        }
        qr/Parameters 'SSPPageToken' and 'SSPID' is required/, 'SSPID is undef';

        throws_ok {
            $app->ssp_context_on_site_campaign->do_action($id, "edit", patch => {"__DEL__" => ["SSPPageToken"],});
        }
        qr/Parameters 'SSPPageToken' and 'SSPID' is required/, 'no SSPPageToken';

        throws_ok {
            $app->ssp_context_on_site_campaign->do_action($id, "edit", patch => {SSPPageToken => {},});
        }
        qr/Some token in parameter 'SSPPageToken' incorrect/, 'bad SSPPageToken';

        throws_ok {
            $app->ssp_context_on_site_campaign->do_action($id, "edit", patch => {SSPPageToken => [undef],});
        }
        qr/Some token in parameter 'SSPPageToken' incorrect/, 'bad SSPPageToken';

        lives_ok {
            $app->ssp_context_on_site_campaign->do_action($id, "edit", patch => {SSPPageToken => ['mail.ru'],});
        }
        'ok edit';

        # т.к. в mocked_database появилась новая запись нужно ее удалить,
        # иначе получаем Duplicate entry '423453' for key 'uniq_ssp_link_context_rtb__context_rtb_id',
        $app->ssp_context_on_site_campaign->ssp_links->partner_db_table->delete(
            $app->partner_db->filter({context_rtb_id => 423453,}));

        $app->ssp_context_on_site_campaign->ssp_links->partner_db_table->add(
            {
                seller_id      => 7952356,
                tokens         => '["mail.ru"]',
                context_rtb_id => 423453,
            }
        );

        throws_ok {
            $app->ssp_context_on_site_campaign->do_action($id, "edit", patch => {SSPPageToken => ['xxxxx'],});
        }
        qr/Exists SSPID with this Token for PageID=/, 'bad token';
    },
    user               => 'mocked-yan-manager',
    init               => [qw(ssp_imps)],
    do_not_die_on_fail => 1
);
