#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 20;
use Test::Deep;
use Test::MockObject::Extends;

use qbit;

use Test::Partner2::Simple;
use Utils::MonitoringUtils;

$ENV{LAZY_LOAD} = FALSE;

run_tests(
    sub {
        my ($app) = @_;

        my @data = (
            {
                'value' => ignore(),
                'path'  => 'SSP.Link.MobileApp.link_process_age',
                solomon => {
                    sensor => 'SSP.Link.MobileApp.link',
                    metric => 'process_age',
                }
            },
            {
                'value' => 0,
                'path'  => 'SSP.Link.MobileApp.link_count_sources',
                solomon => {
                    sensor => 'SSP.Link.MobileApp.link',
                    metric => 'count_sources',
                }
            },
            {
                'value' => 0,
                'path'  => 'SSP.Link.MobileApp.link_count_updated',
                solomon => {
                    sensor => 'SSP.Link.MobileApp.link',
                    metric => 'count_updated',
                }
            },
            {
                'value' => 0,
                'path'  => 'SSP.Link.MobileApp.link_count_created',
                solomon => {
                    sensor => 'SSP.Link.MobileApp.link',
                    metric => 'count_created',
                }
            },

            {
                'value' => ignore(),
                'path'  => 'SSP.Link.VideoApp.link_process_age',
                solomon => {
                    sensor => 'SSP.Link.VideoApp.link',
                    metric => 'process_age',
                }
            },
            {
                'value' => 0,
                'path'  => 'SSP.Link.VideoApp.link_count_sources',
                solomon => {
                    sensor => 'SSP.Link.VideoApp.link',
                    metric => 'count_sources',
                }
            },

            {
                'value' => ignore(),
                'path'  => 'SSP.Link.ContextRTB.link_process_age',
                solomon => {
                    sensor => 'SSP.Link.ContextRTB.link',
                    metric => 'process_age',
                }
            },
            {
                'value' => 0,
                'path'  => 'SSP.Link.ContextRTB.link_count_sources',
                solomon => {
                    sensor => 'SSP.Link.ContextRTB.link',
                    metric => 'count_sources',
                }
            },
            {
                'value' => 0,
                'path'  => 'SSP.Link.ContextRTB.link_count_updated',
                solomon => {
                    sensor => 'SSP.Link.ContextRTB.link',
                    metric => 'count_updated',
                }
            },
            {
                'value' => 0,
                'path'  => 'SSP.Link.ContextRTB.link_count_created',
                solomon => {
                    sensor => 'SSP.Link.ContextRTB.link',
                    metric => 'count_created',
                }
            },
            {
                'interval' => 'one_hour',
                'value'    => ignore(),
                'path'     => 'SSP.ImpressionLog.impressions_process_age',
                solomon    => {
                    metric => 'process_age',
                    sensor => 'SSP.ImpressionLog.impressions',
                }
            },
            {
                'interval' => 'one_hour',
                'value'    => 1,
                'path'     => 'SSP.ImpressionLog.impressions_count_bk',
                solomon    => {
                    metric => 'count_bk',
                    sensor => 'SSP.ImpressionLog.impressions',
                }
            },
            {
                'interval' => 'one_hour',
                'value'    => 1,
                'path'     => 'SSP.ImpressionLog.impressions_count_normalized',
                solomon    => {
                    metric => 'count_normalized',
                    sensor => 'SSP.ImpressionLog.impressions',
                }
            },
            {
                'interval' => 'one_hour',
                'value'    => 1,
                'path'     => 'SSP.ImpressionLog.impressions_count_processed',
                solomon    => {
                    metric => 'count_processed',
                    sensor => 'SSP.ImpressionLog.impressions',
                }
            },
            {
                'interval' => 'one_hour',
                'value'    => 0,
                'path'     => 'SSP.ImpressionLog.impressions_count_processed_app_ok',
                solomon    => {
                    metric => 'count_processed_app_ok',
                    sensor => 'SSP.ImpressionLog.impressions',
                }
            },
            {
                'interval' => 'one_hour',
                'value'    => 0,
                'path'     => 'SSP.ImpressionLog.impressions_count_processed_app_missed',
                solomon    => {
                    metric => 'count_processed_app_missed',
                    sensor => 'SSP.ImpressionLog.impressions',
                }
            },
            {
                'interval' => 'one_hour',
                'value'    => 0,
                'path'     => 'SSP.ImpressionLog.impressions_count_processed_site_ok',
                solomon    => {
                    metric => 'count_processed_site_ok',
                    sensor => 'SSP.ImpressionLog.impressions',
                }
            },
            {
                'interval' => 'one_hour',
                'value'    => 0,
                'path'     => 'SSP.ImpressionLog.impressions_count_processed_site_missed',
                solomon    => {
                    metric => 'count_processed_site_missed',
                    sensor => 'SSP.ImpressionLog.impressions',
                }
            }
        );

        no warnings 'redefine';
        no strict 'refs';
        *{'Application::Model::Product::SSP::Link::MobileApp::send_to_graphite'} = sub {
            my %data = @_;
            cmp_deeply(\%data, shift @data, 'results sent to graphite');
        };
        *{'Application::Model::Product::SSP::Link::VideoApp::send_to_graphite'} = sub {
            my %data = @_;
            cmp_deeply(\%data, shift @data, 'results sent to graphite');
        };
        *{'Application::Model::Product::SSP::Link::ContextRTB::send_to_graphite'} = sub {
            my %data = @_;
            cmp_deeply(\%data, shift @data, 'results sent to graphite');
        };
        *{'Application::Model::Product::SSP::ImpressionLog::send_to_graphite'} = sub {
            my %data = @_;
            cmp_deeply(\%data, shift @data, 'results sent to graphite');
        };
        *{'Application::Model::Product::SSP::ImpressionLog::extract_app_os_id'} = sub {return 3;};

        no warnings 'once';
        $Application::Model::Product::SSP::ImpressionLog::MIN_ROWS = 0;
        $app->{'ssp_imps'} = Test::MockObject::Extends->new($app->{'ssp_imps'});
        $app->ssp_imps->mock(
            'get_ssp_impression_log',
            sub {
                return [
                    {
                        'PageID'         => '153979',
                        'ExportOS'       => 'iOS',
                        'ExportTokenMD5' => '5812379953198983313',
                        'Type'           => 'app-media',
                        'ExportToken'    => '1236833677',
                        'UpdateTime'     => '2018-01-30 00:00:00',
                        'Hits'           => '35103',
                        'SSPID'          => '7952356',
                        'ExportDomain'   => '1236833677'
                    },
                ];
            }
        );
        *{'Application::Model::PartnerDB::transaction'} = sub {return};

        $app->ssp_link_mobile_app->update_data('2018-01-30');
        $app->ssp_link_video_app->update_data('2018-01-30');
        $app->ssp_link_context_rtb->update_data('2018-01-30');
        $app->ssp_imps->update_data('2018-01-30');
    },
    do_not_die_on_fail => 1,
    init               => [qw(api_http_bk ssp_imps)],
);
