#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Deep;
use Test::Partner2::Simple;

use qbit;

my $FIXTURES = [
    {
        name     => 'send by user_id',
        params   => {'user_id' => 1009},
        expected => [{'name' => 'No name', 'email' => 'devnull@yandex.ru'}],
    },
    {
        name     => 'send by default',
        params   => 'default',
        expected => [
            {
                'email' => 'support@partner.yandex.ru',
                'name'  => 'Yandex partner interface'
            }
        ],
    },
    {
        name     => 'send by email',
        params   => 'test.to@mail.com',
        expected => [
            {
                'email' => 'test.to@mail.com',
                'name'  => ''
            }
        ],
    },
    {
        name     => 'send by email and name',
        params   => {'test.to@mail.com' => 'Pikachu'},
        expected => [
            {
                'email' => 'test.to@mail.com',
                'name'  => 'Pikachu'
            }
        ],
    },
    {
        name   => 'send by array',
        params => [
            {'user_id' => 1009},
            'default', 'test.to@mail.com',
            {'test2.to@mail.com' => 'Pikachu'},
            'test3.to@mail.com, test4.to@mail.com',
            {'test5.to@mail.com , test6.to@mail.com' => 'Bulbasaur'}
        ],
        expected => [
            {
                'email' => 'devnull@yandex.ru',
                'name'  => 'No name'
            },
            {
                'email' => 'support@partner.yandex.ru',
                'name'  => 'Yandex partner interface'
            },
            {
                'email' => 'test.to@mail.com',
                'name'  => ''
            },
            {
                'email' => 'test2.to@mail.com',
                'name'  => 'Pikachu'
            },
            {
                'email' => 'test3.to@mail.com',
                'name'  => ''
            },
            {
                'email' => 'test4.to@mail.com',
                'name'  => ''
            },
            {
                'email' => 'test5.to@mail.com',
                'name'  => 'Bulbasaur'
            },
            {
                'email' => 'test6.to@mail.com',
                'name'  => 'Bulbasaur'
            }
        ],
    },
];

run_tests(
    sub {
        my ($app) = @_;

        my %opts =
          (subject => 'Test subject', body => 'Test body', to => 'test.to@email.com', from => 'test.from@email.com');

        foreach my $test (@$FIXTURES) {
            foreach my $field (qw(to from cc bcc reply_to)) {
                my $data = $app->mailer->_message_struct_in({%opts, $field => $test->{'params'}}, 'hash');

                my $expected = $test->{'expected'};

                if ($field eq 'from' || $field eq 'reply_to') {
                    $expected = [$expected->[0]];
                }

                cmp_deeply(
                    $data,
                    {
                        %opts,
                        content_type => 'text/plain',
                        (map {$_ => undef} qw(attachments bcc cc reply_to source_spot)),
                        to => [
                            {
                                'email' => 'test.to@email.com',
                                'name'  => ''
                            }
                        ],
                        from => [
                            {
                                'email' => 'test.from@email.com',
                                'name'  => ''
                            }
                        ],
                        $field => $expected,
                    },
                    $field . ': ' . $test->{'name'}
                );
            }
        }
    },
);
