#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;
use Test::Partner::Utils;
use Test::Differences;

use PiConstants qw(:ROLES);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $id = $app->simple_notification->add(
            message => {
                en => 'En message',
                ru => 'Ру сообщение',
            },
            ntype => 'default',
            roles => [$SITE_PARTNER_ROLE_ID],
        );

        my %got;
        change_cur_user($app, 'mocked-yan-partner');
        $got{before} = $app->simple_notification->get_all();

        change_cur_user($app, 'yndx-developer');
        $app->simple_notification->do_action($id, 'delete');

        change_cur_user($app, 'mocked-yan-partner');
        $got{after} = $app->simple_notification->get_all();

        my $has = get_test_data_and_update_if_needed('data.json', \%got);
        eq_or_diff($has, from_json(to_json(\%got)), 'Verify data');

    },
    user               => 'yndx-developer',
    do_not_die_on_fail => 1,
);
