use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Differences;
use Test::Partner2::Mock;
use PiConstants qw(:ROLES);

run_tests(\&main_test, init => ['users', 'simple_notification', 'documents']);

sub main_test {
    my ($app) = @_;
    my ($check_game_offer, $is_resident);
    my_mocks(\$check_game_offer, \$is_resident);

    $app->simple_notification->add(
        message => {
            en => 'En message',
            ru => 'Ру сообщение',
        },
        ntype      => 'action_banner',
        short_name => 'goto_game_offer_rez',
        roles      => [$SITE_PARTNER_ROLE_ID],
    );
    $app->simple_notification->add(
        message => {
            en => 'En message',
            ru => 'Ру сообщение',
        },
        ntype      => 'action_banner',
        short_name => 'goto_game_offer_notrez',
        roles      => [$SITE_PARTNER_ROLE_ID],
    );

    change_cur_user($app, 'mocked-yan-partner');
    $check_game_offer = {active_contract => {Person => {type => 'ur',}}};
    my @got;
    $is_resident = 1;
    push @got, ['rez_ur', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    $is_resident = 0;
    push @got, ['notrez_nby', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    $check_game_offer = {active_contract => {Person => {type => 'ph',}}};
    $is_resident = 1;
    push @got, ['rez_ph', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    $app->partner_db->form_data->add({user_id => 1009, country_id => 149, client_id => 11009});
    $is_resident = 0;
    push @got, ['notrez_by', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    my $has = get_test_data_and_update_if_needed('data.json', \@got);
    eq_or_diff(from_json(to_json(\@got)), $has, 'Verify data');

}

sub my_mocks {
    my ($check_game_offer, $is_resident) = @_;
    mock_subs(
        {
            'Application::Model::Users::check_game_offer' => sub {
                return $$check_game_offer;
            },
            'Application::Model::Documents::is_resident' => sub {
                return $$is_resident;
            },
        }
    );
}
