use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Differences;
use Test::Partner2::Mock;
use PiConstants qw(:ROLES);

use qbit;

run_tests(\&main_test, init => ['users', 'simple_notification', 'documents']);

sub main_test {
    my ($app) = @_;

    $app->simple_notification->add(
        message => {
            en => 'En message',
            ru => 'Ру сообщение',
        },
        ntype      => 'action_banner',
        short_name => 'fill_requisites',
        roles      => [$SITE_PARTNER_ROLE_ID],
    );

    $app->simple_notification->add(
        message => {
            en => 'En message',
            ru => 'Ру сообщение',
        },
        ntype      => 'action_banner',
        short_name => 'fill_requisites_games',
        roles      => [$SITE_PARTNER_ROLE_ID],
    );

    my $cur_user = change_cur_user($app, 'mocked-yan-partner');

    my @got;

    $app->partner_db->users->edit($cur_user, {opts => {json_set => ['opts', \'$.is_form_done', \0]}, 'is_games' => 0});
    push @got, ['is_form_done = 0 is_games = 0', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    $app->partner_db->users->edit($cur_user, {'is_games' => 1});
    push @got,
      ['is_form_done = 0 and is_games = 1', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    $app->partner_db->users->edit($cur_user, {opts => {json_set => ['opts', \'$.is_form_done', \1]}});
    push @got, ['is_form_done = 1', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    my $has = get_test_data_and_update_if_needed('data.json', \@got);
    eq_or_diff(from_json(to_json(\@got)), $has, 'Verify data');

}
