use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Differences;
use Test::Partner2::Mock;
use PiConstants qw(:ROLES);

use qbit;

run_tests(\&main_test, init => ['users', 'simple_notification', 'documents']);

sub main_test {
    my ($app) = @_;

    $app->simple_notification->add(
        message => {
            en => 'En message',
            ru => 'Ру сообщение',
        },
        ntype      => 'action_banner',
        short_name => 'ua_payment_banner',
        roles      => [$SITE_PARTNER_ROLE_ID],
    );

    my $cur_user = change_cur_user($app, 'mocked-yan-partner');

    my @got;

    push @got,
      ['without_feature ua_payment_banner', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    $app->user_features->add($cur_user->{id}, 'ua_payment_banner');

    push @got, ['with_feature ua_payment_banner', [grep {$_->{show_message}} @{$app->simple_notification->get_all()}]];

    my $has = get_test_data_and_update_if_needed('data.json', \@got);
    eq_or_diff(from_json(to_json(\@got)), $has, 'Verify data');

}
