#!/usr/bin/perl -w

use Test::Differences;
use Test::More;

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Mock;

use qbit;

use PiConstants qw(:ROLES);

run_tests(
    sub {
        my ($app) = @_;

        $app->simple_notification->add(
            message => {
                en => 'En message',
                ru => 'Ру сообщение',
            },
            ntype      => 'action_banner',
            short_name => 'welcome_mobile',
            roles      => [$MOBILE_PARTNER_ROLE_ID],
        );

        my @results;

        change_cur_user($app, 'mocked-mobile-app-partner');
        push @results,
          [
            'mobile-user with pages',
            [map {$_->{short_name}} grep {$_->{show_message}} @{$app->simple_notification->get_all()}]
          ];

        mock_subs({'Application::Model::Product::AN::MobileApp::Settings::get_all' => sub {[]},});
        push @results,
          [
            'mobile-user without pages',
            [map {$_->{short_name}} grep {$_->{show_message}} @{$app->simple_notification->get_all()}]
          ];

        change_cur_user($app, 'mocked-yan-partner');
        push @results,
          [
            'web-user without pages',
            [map {$_->{short_name}} grep {$_->{show_message}} @{$app->simple_notification->get_all()}]
          ];

        my $expected = get_test_data_and_update_if_needed('data.json', \@results);
        eq_or_diff(from_json(to_json(\@results)), $expected, 'Verify data');
    }
);
